package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * KeepMeSignedIn
 */
@JsonPropertyOrder({ KeepMeSignedIn.JSON_PROPERTY_POST_AUTH, KeepMeSignedIn.JSON_PROPERTY_POST_AUTH_PROMPT_FREQUENCY })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class KeepMeSignedIn implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Whether the post-authentication Keep Me Signed In flow is allowed
     */
    public enum PostAuthEnum {
        ALLOWED(String.valueOf("ALLOWED")),

        NOT_ALLOWED(String.valueOf("NOT_ALLOWED")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        PostAuthEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static PostAuthEnum fromValue(String value) {
            for (PostAuthEnum b : PostAuthEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_POST_AUTH = "postAuth";
    private PostAuthEnum postAuth;

    public static final String JSON_PROPERTY_POST_AUTH_PROMPT_FREQUENCY = "postAuthPromptFrequency";
    private String postAuthPromptFrequency;

    public KeepMeSignedIn() {
    }

    public KeepMeSignedIn postAuth(PostAuthEnum postAuth) {

        this.postAuth = postAuth;
        return this;
    }

    /**
     * Whether the post-authentication Keep Me Signed In flow is allowed
     *
     * @return postAuth
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Whether the post-authentication Keep Me Signed In flow is allowed")
    @JsonProperty(JSON_PROPERTY_POST_AUTH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PostAuthEnum getPostAuth() {
        return postAuth;
    }

    @JsonProperty(JSON_PROPERTY_POST_AUTH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPostAuth(PostAuthEnum postAuth) {
        this.postAuth = postAuth;
    }

    public KeepMeSignedIn postAuthPromptFrequency(String postAuthPromptFrequency) {

        this.postAuthPromptFrequency = postAuthPromptFrequency;
        return this;
    }

    /**
     * A time duration specified as an [ISO-8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).
     *
     * @return postAuthPromptFrequency
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A time duration specified as an [ISO-8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations).")
    @JsonProperty(JSON_PROPERTY_POST_AUTH_PROMPT_FREQUENCY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPostAuthPromptFrequency() {
        return postAuthPromptFrequency;
    }

    @JsonProperty(JSON_PROPERTY_POST_AUTH_PROMPT_FREQUENCY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPostAuthPromptFrequency(String postAuthPromptFrequency) {
        this.postAuthPromptFrequency = postAuthPromptFrequency;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        KeepMeSignedIn keepMeSignedIn = (KeepMeSignedIn) o;
        return Objects.equals(this.postAuth, keepMeSignedIn.postAuth)
                && Objects.equals(this.postAuthPromptFrequency, keepMeSignedIn.postAuthPromptFrequency);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(postAuth, postAuthPromptFrequency);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeepMeSignedIn {\n");
        sb.append("    postAuth: ").append(toIndentedString(postAuth)).append("\n");
        sb.append("    postAuthPromptFrequency: ").append(toIndentedString(postAuthPromptFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
