package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinkedObjectDetails;
import com.okta.sdk.resource.model.LinkedObjectLinksSelf;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * LinkedObject
 */
@JsonPropertyOrder({ LinkedObject.JSON_PROPERTY_ASSOCIATED, LinkedObject.JSON_PROPERTY_PRIMARY,
        LinkedObject.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LinkedObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ASSOCIATED = "associated";
    private LinkedObjectDetails associated;

    public static final String JSON_PROPERTY_PRIMARY = "primary";
    private LinkedObjectDetails primary;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinkedObjectLinksSelf links;

    public LinkedObject() {
    }

    public LinkedObject associated(LinkedObjectDetails associated) {

        this.associated = associated;
        return this;
    }

    /**
     * Get associated
     *
     * @return associated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASSOCIATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinkedObjectDetails getAssociated() {
        return associated;
    }

    @JsonProperty(JSON_PROPERTY_ASSOCIATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssociated(LinkedObjectDetails associated) {
        this.associated = associated;
    }

    public LinkedObject primary(LinkedObjectDetails primary) {

        this.primary = primary;
        return this;
    }

    /**
     * Get primary
     *
     * @return primary
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PRIMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinkedObjectDetails getPrimary() {
        return primary;
    }

    @JsonProperty(JSON_PROPERTY_PRIMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPrimary(LinkedObjectDetails primary) {
        this.primary = primary;
    }

    public LinkedObject links(LinkedObjectLinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinkedObjectLinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinkedObjectLinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinkedObject linkedObject = (LinkedObject) o;
        return Objects.equals(this.associated, linkedObject.associated)
                && Objects.equals(this.primary, linkedObject.primary) && Objects.equals(this.links, linkedObject.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(associated, primary, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinkedObject {\n");
        sb.append("    associated: ").append(toIndentedString(associated)).append("\n");
        sb.append("    primary: ").append(toIndentedString(primary)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
