package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A &#x60;transaction&#x60; object comprises contextual information associated with its respective event. This
 * information is useful for understanding sequences of correlated events. For example, a &#x60;transaction&#x60; object
 * such as the following: &#x60;&#x60;&#x60; { \&quot;id\&quot;: \&quot;Wn4f-0RQ8D8lTSLkAmkKdQAADqo\&quot;,
 * \&quot;type\&quot;: \&quot;WEB\&quot;, \&quot;detail\&quot;: null } &#x60;&#x60;&#x60; indicates that a
 * &#x60;WEB&#x60; request with &#x60;id&#x60; &#x60;Wn4f-0RQ8D8lTSLkAmkKdQAADqo&#x60; has created this event. A
 * &#x60;transaction&#x60; object with a &#x60;requestApiTokenId&#x60; in the &#x60;detail&#x60; object, for example :
 * &#x60;&#x60;&#x60; { \&quot;id\&quot;: \&quot;YjSlblAAqnKY7CdyCkXNBgAAAIU\&quot;, \&quot;type\&quot;:
 * \&quot;WEB\&quot;, \&quot;detail\&quot;: { \&quot;requestApiTokenId\&quot;: \&quot;00T94e3cn9kSEO3c51s5\&quot; } }
 * &#x60;&#x60;&#x60; indicates that this event was the result of an action performed through an API using the token
 * identified by 00T94e3cn9kSEO3c51s5. The token ID is visible in the Admin Console, **Security** &gt; **API**. See [API
 * token management](https://help.okta.com/okta_help.htm?id&#x3D;Security_API). For more information on API tokens, see
 * [Create an API token](https://developer.okta.com/docs/guides/create-an-api-token/).
 */
@ApiModel(description = "A `transaction` object comprises contextual information associated with its respective event.  This information is useful for understanding sequences of correlated events. For example, a `transaction` object such as the following: ``` {   \"id\": \"Wn4f-0RQ8D8lTSLkAmkKdQAADqo\",   \"type\": \"WEB\",   \"detail\": null } ``` indicates that a `WEB` request with `id` `Wn4f-0RQ8D8lTSLkAmkKdQAADqo` has created this event.  A `transaction` object with a `requestApiTokenId` in the `detail` object, for example : ``` {   \"id\": \"YjSlblAAqnKY7CdyCkXNBgAAAIU\",   \"type\": \"WEB\",   \"detail\": {     \"requestApiTokenId\": \"00T94e3cn9kSEO3c51s5\"   } } ``` indicates that this event was the result of an action performed through an API using the token identified by 00T94e3cn9kSEO3c51s5. The token ID is visible in the Admin Console, **Security** > **API**. See [API token management](https://help.okta.com/okta_help.htm?id=Security_API). For more information on API tokens, see [Create an API token](https://developer.okta.com/docs/guides/create-an-api-token/).")
@JsonPropertyOrder({ LogTransaction.JSON_PROPERTY_DETAIL, LogTransaction.JSON_PROPERTY_ID,
        LogTransaction.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LogTransaction implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DETAIL = "detail";
    private Map<String, Object> detail = null;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public LogTransaction() {
    }

    /*
     * @JsonCreator public LogTransaction(
     *
     * @JsonProperty(JSON_PROPERTY_DETAIL) Map<String, Object> detail,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.detail = detail; this.id = id; this.type = type; }
     */

    /**
     * Details for this transaction.
     *
     * @return detail
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Details for this transaction.")
    @JsonProperty(JSON_PROPERTY_DETAIL)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getDetail() {
        return detail;
    }

    /**
     * Unique identifier for this transaction.
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for this transaction.")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Describes the kind of transaction. &#x60;WEB&#x60; indicates a web request. &#x60;JOB&#x60; indicates an
     * asynchronous task.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Describes the kind of transaction. `WEB` indicates a web request. `JOB` indicates an asynchronous task.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogTransaction logTransaction = (LogTransaction) o;
        return Objects.equals(this.detail, logTransaction.detail) && Objects.equals(this.id, logTransaction.id)
                && Objects.equals(this.type, logTransaction.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(detail, id, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogTransaction {\n");
        sb.append("    detail: ").append(toIndentedString(detail)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
