package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GrantResourcesHrefObject;
import com.okta.sdk.resource.model.HrefObjectSelfLink;
import com.okta.sdk.resource.model.TokenResourcesHrefObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2ClientLinks
 */
@JsonPropertyOrder({ OAuth2ClientLinks.JSON_PROPERTY_SELF, OAuth2ClientLinks.JSON_PROPERTY_GRANTS,
        OAuth2ClientLinks.JSON_PROPERTY_TOKENS })
@JsonTypeName("OAuth2Client__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OAuth2ClientLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SELF = "self";
    private HrefObjectSelfLink self;

    public static final String JSON_PROPERTY_GRANTS = "grants";
    private GrantResourcesHrefObject grants;

    public static final String JSON_PROPERTY_TOKENS = "tokens";
    private TokenResourcesHrefObject tokens;

    public OAuth2ClientLinks() {
    }

    public OAuth2ClientLinks self(HrefObjectSelfLink self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectSelfLink getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(HrefObjectSelfLink self) {
        this.self = self;
    }

    public OAuth2ClientLinks grants(GrantResourcesHrefObject grants) {

        this.grants = grants;
        return this;
    }

    /**
     * Link to the grant resources
     *
     * @return grants
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the grant resources")
    @JsonProperty(JSON_PROPERTY_GRANTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GrantResourcesHrefObject getGrants() {
        return grants;
    }

    @JsonProperty(JSON_PROPERTY_GRANTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGrants(GrantResourcesHrefObject grants) {
        this.grants = grants;
    }

    public OAuth2ClientLinks tokens(TokenResourcesHrefObject tokens) {

        this.tokens = tokens;
        return this;
    }

    /**
     * Link to the token resources
     *
     * @return tokens
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Link to the token resources")
    @JsonProperty(JSON_PROPERTY_TOKENS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TokenResourcesHrefObject getTokens() {
        return tokens;
    }

    @JsonProperty(JSON_PROPERTY_TOKENS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTokens(TokenResourcesHrefObject tokens) {
        this.tokens = tokens;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientLinks oauth2ClientLinks = (OAuth2ClientLinks) o;
        return Objects.equals(this.self, oauth2ClientLinks.self)
                && Objects.equals(this.grants, oauth2ClientLinks.grants)
                && Objects.equals(this.tokens, oauth2ClientLinks.tokens);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, grants, tokens);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientLinks {\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    grants: ").append(toIndentedString(grants)).append("\n");
        sb.append("    tokens: ").append(toIndentedString(tokens)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
