package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuth2RefreshTokenScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The embedded resources related to the object if the &#x60;expand&#x60; query parameter is specified
 */
@ApiModel(description = "The embedded resources related to the object if the `expand` query parameter is specified")
@JsonPropertyOrder({ OAuth2RefreshTokenEmbedded.JSON_PROPERTY_SCOPES })
@JsonTypeName("OAuth2RefreshToken__embedded")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OAuth2RefreshTokenEmbedded implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<OAuth2RefreshTokenScope> scopes = null;

    public OAuth2RefreshTokenEmbedded() {
    }

    public OAuth2RefreshTokenEmbedded scopes(List<OAuth2RefreshTokenScope> scopes) {

        this.scopes = scopes;
        return this;
    }

    public OAuth2RefreshTokenEmbedded addscopesItem(OAuth2RefreshTokenScope scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    /**
     * The scope objects attached to the Token
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The scope objects attached to the Token")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<OAuth2RefreshTokenScope> getScopes() {
        return scopes;
    }

    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<OAuth2RefreshTokenScope> scopes) {
        this.scopes = scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2RefreshTokenEmbedded oauth2RefreshTokenEmbedded = (OAuth2RefreshTokenEmbedded) o;
        return Objects.equals(this.scopes, oauth2RefreshTokenEmbedded.scopes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(scopes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2RefreshTokenEmbedded {\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
