package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationCredentialsOAuthClient;
import com.okta.sdk.resource.model.ApplicationCredentialsSigning;
import com.okta.sdk.resource.model.ApplicationCredentialsUsernameTemplate;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuthApplicationCredentials
 */
@JsonPropertyOrder({ OAuthApplicationCredentials.JSON_PROPERTY_SIGNING,
        OAuthApplicationCredentials.JSON_PROPERTY_USER_NAME_TEMPLATE,
        OAuthApplicationCredentials.JSON_PROPERTY_OAUTH_CLIENT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OAuthApplicationCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SIGNING = "signing";
    private ApplicationCredentialsSigning signing;

    public static final String JSON_PROPERTY_USER_NAME_TEMPLATE = "userNameTemplate";
    private ApplicationCredentialsUsernameTemplate userNameTemplate;

    public static final String JSON_PROPERTY_OAUTH_CLIENT = "oauthClient";
    private ApplicationCredentialsOAuthClient oauthClient;

    public OAuthApplicationCredentials() {
    }

    public OAuthApplicationCredentials signing(ApplicationCredentialsSigning signing) {

        this.signing = signing;
        return this;
    }

    /**
     * Get signing
     *
     * @return signing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsSigning getSigning() {
        return signing;
    }

    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSigning(ApplicationCredentialsSigning signing) {
        this.signing = signing;
    }

    public OAuthApplicationCredentials userNameTemplate(ApplicationCredentialsUsernameTemplate userNameTemplate) {

        this.userNameTemplate = userNameTemplate;
        return this;
    }

    /**
     * Get userNameTemplate
     *
     * @return userNameTemplate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_NAME_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsUsernameTemplate getUserNameTemplate() {
        return userNameTemplate;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserNameTemplate(ApplicationCredentialsUsernameTemplate userNameTemplate) {
        this.userNameTemplate = userNameTemplate;
    }

    public OAuthApplicationCredentials oauthClient(ApplicationCredentialsOAuthClient oauthClient) {

        this.oauthClient = oauthClient;
        return this;
    }

    /**
     * Get oauthClient
     *
     * @return oauthClient
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OAUTH_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsOAuthClient getOauthClient() {
        return oauthClient;
    }

    @JsonProperty(JSON_PROPERTY_OAUTH_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOauthClient(ApplicationCredentialsOAuthClient oauthClient) {
        this.oauthClient = oauthClient;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuthApplicationCredentials oauthApplicationCredentials = (OAuthApplicationCredentials) o;
        return Objects.equals(this.signing, oauthApplicationCredentials.signing)
                && Objects.equals(this.userNameTemplate, oauthApplicationCredentials.userNameTemplate)
                && Objects.equals(this.oauthClient, oauthApplicationCredentials.oauthClient);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(signing, userNameTemplate, oauthClient);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthApplicationCredentials {\n");
        sb.append("    signing: ").append(toIndentedString(signing)).append("\n");
        sb.append("    userNameTemplate: ").append(toIndentedString(userNameTemplate)).append("\n");
        sb.append("    oauthClient: ").append(toIndentedString(oauthClient)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
