package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppleClientSigning;
import com.okta.sdk.resource.model.OAuthCredentialsClient;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Client authentication credentials for an [OAuth 2.0 Authorization
 * Server](https://tools.ietf.org/html/rfc6749#section-2.3)
 */
@ApiModel(description = "Client authentication credentials for an [OAuth 2.0 Authorization Server](https://tools.ietf.org/html/rfc6749#section-2.3)")
@JsonPropertyOrder({ OAuthCredentials.JSON_PROPERTY_CLIENT, OAuthCredentials.JSON_PROPERTY_SIGNING })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OAuthCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT = "client";
    private OAuthCredentialsClient client;

    public static final String JSON_PROPERTY_SIGNING = "signing";
    private AppleClientSigning signing;

    public OAuthCredentials() {
    }

    public OAuthCredentials client(OAuthCredentialsClient client) {

        this.client = client;
        return this;
    }

    /**
     * Get client
     *
     * @return client
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthCredentialsClient getClient() {
        return client;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClient(OAuthCredentialsClient client) {
        this.client = client;
    }

    public OAuthCredentials signing(AppleClientSigning signing) {

        this.signing = signing;
        return this;
    }

    /**
     * Get signing
     *
     * @return signing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppleClientSigning getSigning() {
        return signing;
    }

    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSigning(AppleClientSigning signing) {
        this.signing = signing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuthCredentials oauthCredentials = (OAuthCredentials) o;
        return Objects.equals(this.client, oauthCredentials.client)
                && Objects.equals(this.signing, oauthCredentials.signing);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(client, signing);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthCredentials {\n");
        sb.append("    client: ").append(toIndentedString(client)).append("\n");
        sb.append("    signing: ").append(toIndentedString(signing)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
