package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OidcRequestSignatureAlgorithm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Algorithm settings used to sign an authorization request
 */
@ApiModel(description = "Algorithm settings used to sign an authorization request")
@JsonPropertyOrder({ OidcRequestAlgorithm.JSON_PROPERTY_SIGNATURE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OidcRequestAlgorithm implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private OidcRequestSignatureAlgorithm signature;

    public OidcRequestAlgorithm() {
    }

    public OidcRequestAlgorithm signature(OidcRequestSignatureAlgorithm signature) {

        this.signature = signature;
        return this;
    }

    /**
     * Get signature
     *
     * @return signature
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGNATURE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OidcRequestSignatureAlgorithm getSignature() {
        return signature;
    }

    @JsonProperty(JSON_PROPERTY_SIGNATURE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignature(OidcRequestSignatureAlgorithm signature) {
        this.signature = signature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OidcRequestAlgorithm oidcRequestAlgorithm = (OidcRequestAlgorithm) o;
        return Objects.equals(this.signature, oidcRequestAlgorithm.signature);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(signature);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OidcRequestAlgorithm {\n");
        sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
