package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObjectUserLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the Contact Type
 * User object using the [JSON Hypertext Application
 * Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the Contact Type User object using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ OrgContactUserLinks.JSON_PROPERTY_USER })
@JsonTypeName("OrgContactUser__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgContactUserLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_USER = "user";
    private HrefObjectUserLink user;

    public OrgContactUserLinks() {
    }

    public OrgContactUserLinks user(HrefObjectUserLink user) {

        this.user = user;
        return this;
    }

    /**
     * Get user
     *
     * @return user
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectUserLink getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUser(HrefObjectUserLink user) {
        this.user = user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgContactUserLinks orgContactUserLinks = (OrgContactUserLinks) o;
        return Objects.equals(this.user, orgContactUserLinks.user);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(user);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgContactUserLinks {\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
