package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The parameter value of the command. * To indicate that the supplied credentials are valid, supply a type property set
 * to &#x60;com.okta.action.update&#x60; together with a value property set to &#x60;{\&quot;credential\&quot;:
 * \&quot;VERIFIED\&quot;}&#x60;. * To indicate that the supplied credentials are invalid, supply a type property set to
 * &#x60;com.okta.action.update&#x60; together with a value property set to &#x60;{\&quot;credential\&quot;:
 * \&quot;UNVERIFIED\&quot;}&#x60;. Alternatively, you can send an empty response (&#x60;204&#x60;). By default, the
 * &#x60;data.action.credential&#x60; is always set to &#x60;UNVERIFIED&#x60;.
 */
@ApiModel(description = "The parameter value of the command. * To indicate that the supplied credentials are valid, supply a type property set to `com.okta.action.update` together with a value property set to `{\"credential\": \"VERIFIED\"}`. * To indicate that the supplied credentials are invalid, supply a type property set to `com.okta.action.update` together with a value property set to `{\"credential\": \"UNVERIFIED\"}`. Alternatively, you can send an empty response (`204`). By default, the `data.action.credential` is always set to `UNVERIFIED`.")
@JsonPropertyOrder({ PasswordImportResponseCommandsInnerValue.JSON_PROPERTY_CREDENTIAL })
@JsonTypeName("PasswordImportResponse_commands_inner_value")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PasswordImportResponseCommandsInnerValue implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets credential
     */
    public enum CredentialEnum {
        UNVERIFIED(String.valueOf("UNVERIFIED")),

        VERIFIED(String.valueOf("VERIFIED")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        CredentialEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static CredentialEnum fromValue(String value) {
            for (CredentialEnum b : CredentialEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_CREDENTIAL = "credential";
    private CredentialEnum credential;

    public PasswordImportResponseCommandsInnerValue() {
    }

    public PasswordImportResponseCommandsInnerValue credential(CredentialEnum credential) {

        this.credential = credential;
        return this;
    }

    /**
     * Get credential
     *
     * @return credential
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CredentialEnum getCredential() {
        return credential;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredential(CredentialEnum credential) {
        this.credential = credential;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordImportResponseCommandsInnerValue passwordImportResponseCommandsInnerValue = (PasswordImportResponseCommandsInnerValue) o;
        return Objects.equals(this.credential, passwordImportResponseCommandsInnerValue.credential);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credential);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordImportResponseCommandsInnerValue {\n");
        sb.append("    credential: ").append(toIndentedString(credential)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
