package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PasswordDictionary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Complexity settings
 */
@ApiModel(description = "Complexity settings")
@JsonPropertyOrder({ PasswordPolicyPasswordSettingsComplexity.JSON_PROPERTY_DICTIONARY,
        PasswordPolicyPasswordSettingsComplexity.JSON_PROPERTY_EXCLUDE_ATTRIBUTES,
        PasswordPolicyPasswordSettingsComplexity.JSON_PROPERTY_EXCLUDE_USERNAME,
        PasswordPolicyPasswordSettingsComplexity.JSON_PROPERTY_MIN_LENGTH,
        PasswordPolicyPasswordSettingsComplexity.JSON_PROPERTY_MIN_LOWER_CASE,
        PasswordPolicyPasswordSettingsComplexity.JSON_PROPERTY_MIN_NUMBER,
        PasswordPolicyPasswordSettingsComplexity.JSON_PROPERTY_MIN_SYMBOL,
        PasswordPolicyPasswordSettingsComplexity.JSON_PROPERTY_MIN_UPPER_CASE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PasswordPolicyPasswordSettingsComplexity implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DICTIONARY = "dictionary";
    private PasswordDictionary dictionary;

    public static final String JSON_PROPERTY_EXCLUDE_ATTRIBUTES = "excludeAttributes";
    private List<String> excludeAttributes = null;

    public static final String JSON_PROPERTY_EXCLUDE_USERNAME = "excludeUsername";
    private Boolean excludeUsername = true;

    public static final String JSON_PROPERTY_MIN_LENGTH = "minLength";
    private Integer minLength = 8;

    public static final String JSON_PROPERTY_MIN_LOWER_CASE = "minLowerCase";
    private Integer minLowerCase = 1;

    public static final String JSON_PROPERTY_MIN_NUMBER = "minNumber";
    private Integer minNumber = 1;

    public static final String JSON_PROPERTY_MIN_SYMBOL = "minSymbol";
    private Integer minSymbol = 1;

    public static final String JSON_PROPERTY_MIN_UPPER_CASE = "minUpperCase";
    private Integer minUpperCase = 1;

    public PasswordPolicyPasswordSettingsComplexity() {
    }

    public PasswordPolicyPasswordSettingsComplexity dictionary(PasswordDictionary dictionary) {

        this.dictionary = dictionary;
        return this;
    }

    /**
     * Get dictionary
     *
     * @return dictionary
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DICTIONARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordDictionary getDictionary() {
        return dictionary;
    }

    @JsonProperty(JSON_PROPERTY_DICTIONARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDictionary(PasswordDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public PasswordPolicyPasswordSettingsComplexity excludeAttributes(List<String> excludeAttributes) {

        this.excludeAttributes = excludeAttributes;
        return this;
    }

    public PasswordPolicyPasswordSettingsComplexity addexcludeAttributesItem(String excludeAttributesItem) {
        if (this.excludeAttributes == null) {
            this.excludeAttributes = new ArrayList<>();
        }
        this.excludeAttributes.add(excludeAttributesItem);
        return this;
    }

    /**
     * The User profile attributes whose values must be excluded from the password: currently only supports
     * &#x60;firstName&#x60; and &#x60;lastName&#x60;
     *
     * @return excludeAttributes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The User profile attributes whose values must be excluded from the password: currently only supports `firstName` and `lastName`")
    @JsonProperty(JSON_PROPERTY_EXCLUDE_ATTRIBUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getExcludeAttributes() {
        return excludeAttributes;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE_ATTRIBUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeAttributes(List<String> excludeAttributes) {
        this.excludeAttributes = excludeAttributes;
    }

    public PasswordPolicyPasswordSettingsComplexity excludeUsername(Boolean excludeUsername) {

        this.excludeUsername = excludeUsername;
        return this;
    }

    /**
     * Indicates if the Username must be excluded from the password
     *
     * @return excludeUsername
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the Username must be excluded from the password")
    @JsonProperty(JSON_PROPERTY_EXCLUDE_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getExcludeUsername() {
        return excludeUsername;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE_USERNAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeUsername(Boolean excludeUsername) {
        this.excludeUsername = excludeUsername;
    }

    public PasswordPolicyPasswordSettingsComplexity minLength(Integer minLength) {

        this.minLength = minLength;
        return this;
    }

    /**
     * Minimum password length
     *
     * @return minLength
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Minimum password length")
    @JsonProperty(JSON_PROPERTY_MIN_LENGTH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMinLength() {
        return minLength;
    }

    @JsonProperty(JSON_PROPERTY_MIN_LENGTH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public PasswordPolicyPasswordSettingsComplexity minLowerCase(Integer minLowerCase) {

        this.minLowerCase = minLowerCase;
        return this;
    }

    /**
     * Indicates if a password must contain at least one lower case letter: &#x60;0&#x60; indicates no, &#x60;1&#x60;
     * indicates yes
     *
     * @return minLowerCase
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if a password must contain at least one lower case letter: `0` indicates no, `1` indicates yes")
    @JsonProperty(JSON_PROPERTY_MIN_LOWER_CASE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMinLowerCase() {
        return minLowerCase;
    }

    @JsonProperty(JSON_PROPERTY_MIN_LOWER_CASE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinLowerCase(Integer minLowerCase) {
        this.minLowerCase = minLowerCase;
    }

    public PasswordPolicyPasswordSettingsComplexity minNumber(Integer minNumber) {

        this.minNumber = minNumber;
        return this;
    }

    /**
     * Indicates if a password must contain at least one number: &#x60;0&#x60; indicates no, &#x60;1&#x60; indicates yes
     *
     * @return minNumber
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if a password must contain at least one number: `0` indicates no, `1` indicates yes")
    @JsonProperty(JSON_PROPERTY_MIN_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMinNumber() {
        return minNumber;
    }

    @JsonProperty(JSON_PROPERTY_MIN_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinNumber(Integer minNumber) {
        this.minNumber = minNumber;
    }

    public PasswordPolicyPasswordSettingsComplexity minSymbol(Integer minSymbol) {

        this.minSymbol = minSymbol;
        return this;
    }

    /**
     * Indicates if a password must contain at least one symbol (For example: !@#$%^&amp;*): &#x60;0&#x60; indicates no,
     * &#x60;1&#x60; indicates yes
     *
     * @return minSymbol
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if a password must contain at least one symbol (For example: !@#$%^&*): `0` indicates no, `1` indicates yes")
    @JsonProperty(JSON_PROPERTY_MIN_SYMBOL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMinSymbol() {
        return minSymbol;
    }

    @JsonProperty(JSON_PROPERTY_MIN_SYMBOL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinSymbol(Integer minSymbol) {
        this.minSymbol = minSymbol;
    }

    public PasswordPolicyPasswordSettingsComplexity minUpperCase(Integer minUpperCase) {

        this.minUpperCase = minUpperCase;
        return this;
    }

    /**
     * Indicates if a password must contain at least one upper case letter: &#x60;0&#x60; indicates no, &#x60;1&#x60;
     * indicates yes
     *
     * @return minUpperCase
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if a password must contain at least one upper case letter: `0` indicates no, `1` indicates yes")
    @JsonProperty(JSON_PROPERTY_MIN_UPPER_CASE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getMinUpperCase() {
        return minUpperCase;
    }

    @JsonProperty(JSON_PROPERTY_MIN_UPPER_CASE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinUpperCase(Integer minUpperCase) {
        this.minUpperCase = minUpperCase;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyPasswordSettingsComplexity passwordPolicyPasswordSettingsComplexity = (PasswordPolicyPasswordSettingsComplexity) o;
        return Objects.equals(this.dictionary, passwordPolicyPasswordSettingsComplexity.dictionary)
                && Objects.equals(this.excludeAttributes, passwordPolicyPasswordSettingsComplexity.excludeAttributes)
                && Objects.equals(this.excludeUsername, passwordPolicyPasswordSettingsComplexity.excludeUsername)
                && Objects.equals(this.minLength, passwordPolicyPasswordSettingsComplexity.minLength)
                && Objects.equals(this.minLowerCase, passwordPolicyPasswordSettingsComplexity.minLowerCase)
                && Objects.equals(this.minNumber, passwordPolicyPasswordSettingsComplexity.minNumber)
                && Objects.equals(this.minSymbol, passwordPolicyPasswordSettingsComplexity.minSymbol)
                && Objects.equals(this.minUpperCase, passwordPolicyPasswordSettingsComplexity.minUpperCase);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dictionary, excludeAttributes, excludeUsername, minLength, minLowerCase, minNumber,
                minSymbol, minUpperCase);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicyPasswordSettingsComplexity {\n");
        sb.append("    dictionary: ").append(toIndentedString(dictionary)).append("\n");
        sb.append("    excludeAttributes: ").append(toIndentedString(excludeAttributes)).append("\n");
        sb.append("    excludeUsername: ").append(toIndentedString(excludeUsername)).append("\n");
        sb.append("    minLength: ").append(toIndentedString(minLength)).append("\n");
        sb.append("    minLowerCase: ").append(toIndentedString(minLowerCase)).append("\n");
        sb.append("    minNumber: ").append(toIndentedString(minNumber)).append("\n");
        sb.append("    minSymbol: ").append(toIndentedString(minSymbol)).append("\n");
        sb.append("    minUpperCase: ").append(toIndentedString(minUpperCase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
