package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PasswordPolicyRuleAction;
import com.okta.sdk.resource.model.SelfServicePasswordResetAction;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PasswordPolicyRuleActions
 */
@JsonPropertyOrder({ PasswordPolicyRuleActions.JSON_PROPERTY_PASSWORD_CHANGE,
        PasswordPolicyRuleActions.JSON_PROPERTY_SELF_SERVICE_PASSWORD_RESET,
        PasswordPolicyRuleActions.JSON_PROPERTY_SELF_SERVICE_UNLOCK })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PasswordPolicyRuleActions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASSWORD_CHANGE = "passwordChange";
    private PasswordPolicyRuleAction passwordChange;

    public static final String JSON_PROPERTY_SELF_SERVICE_PASSWORD_RESET = "selfServicePasswordReset";
    private SelfServicePasswordResetAction selfServicePasswordReset;

    public static final String JSON_PROPERTY_SELF_SERVICE_UNLOCK = "selfServiceUnlock";
    private PasswordPolicyRuleAction selfServiceUnlock;

    public PasswordPolicyRuleActions() {
    }

    public PasswordPolicyRuleActions passwordChange(PasswordPolicyRuleAction passwordChange) {

        this.passwordChange = passwordChange;
        return this;
    }

    /**
     * Get passwordChange
     *
     * @return passwordChange
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordPolicyRuleAction getPasswordChange() {
        return passwordChange;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordChange(PasswordPolicyRuleAction passwordChange) {
        this.passwordChange = passwordChange;
    }

    public PasswordPolicyRuleActions selfServicePasswordReset(SelfServicePasswordResetAction selfServicePasswordReset) {

        this.selfServicePasswordReset = selfServicePasswordReset;
        return this;
    }

    /**
     * Get selfServicePasswordReset
     *
     * @return selfServicePasswordReset
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF_SERVICE_PASSWORD_RESET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SelfServicePasswordResetAction getSelfServicePasswordReset() {
        return selfServicePasswordReset;
    }

    @JsonProperty(JSON_PROPERTY_SELF_SERVICE_PASSWORD_RESET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelfServicePasswordReset(SelfServicePasswordResetAction selfServicePasswordReset) {
        this.selfServicePasswordReset = selfServicePasswordReset;
    }

    public PasswordPolicyRuleActions selfServiceUnlock(PasswordPolicyRuleAction selfServiceUnlock) {

        this.selfServiceUnlock = selfServiceUnlock;
        return this;
    }

    /**
     * Get selfServiceUnlock
     *
     * @return selfServiceUnlock
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF_SERVICE_UNLOCK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordPolicyRuleAction getSelfServiceUnlock() {
        return selfServiceUnlock;
    }

    @JsonProperty(JSON_PROPERTY_SELF_SERVICE_UNLOCK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelfServiceUnlock(PasswordPolicyRuleAction selfServiceUnlock) {
        this.selfServiceUnlock = selfServiceUnlock;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyRuleActions passwordPolicyRuleActions = (PasswordPolicyRuleActions) o;
        return Objects.equals(this.passwordChange, passwordPolicyRuleActions.passwordChange)
                && Objects.equals(this.selfServicePasswordReset, passwordPolicyRuleActions.selfServicePasswordReset)
                && Objects.equals(this.selfServiceUnlock, passwordPolicyRuleActions.selfServiceUnlock);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(passwordChange, selfServicePasswordReset, selfServiceUnlock);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicyRuleActions {\n");
        sb.append("    passwordChange: ").append(toIndentedString(passwordChange)).append("\n");
        sb.append("    selfServicePasswordReset: ").append(toIndentedString(selfServicePasswordReset)).append("\n");
        sb.append("    selfServiceUnlock: ").append(toIndentedString(selfServiceUnlock)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
