package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Conditions for further restricting a permission
 */
@ApiModel(description = "Conditions for further restricting a permission")
@JsonPropertyOrder({ PermissionConditions.JSON_PROPERTY_EXCLUDE, PermissionConditions.JSON_PROPERTY_INCLUDE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PermissionConditions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private JsonNullable<Map<String, Object>> exclude = JsonNullable.<Map<String, Object>> undefined();

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private JsonNullable<Map<String, Object>> include = JsonNullable.<Map<String, Object>> undefined();

    public PermissionConditions() {
    }

    public PermissionConditions exclude(Map<String, Object> exclude) {
        this.exclude = JsonNullable.<Map<String, Object>> of(exclude);

        return this;
    }

    public PermissionConditions putexcludeItem(String key, Object excludeItem) {
        if (this.exclude == null || !this.exclude.isPresent()) {
            this.exclude = JsonNullable.<Map<String, Object>> of(null);
        }
        try {
            this.exclude.get().put(key, excludeItem);
        } catch (java.util.NoSuchElementException e) {
            // this can never happen, as we make sure above that the value is present
        }
        return this;
    }

    /**
     * Exclude attributes with specific values for the permission
     *
     * @return exclude
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Exclude attributes with specific values for the permission")
    @JsonIgnore

    public Map<String, Object> getExclude() {
        return exclude.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<Map<String, Object>> getExclude_JsonNullable() {
        return exclude;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    public void setExclude_JsonNullable(JsonNullable<Map<String, Object>> exclude) {
        this.exclude = exclude;
    }

    public void setExclude(Map<String, Object> exclude) {
        this.exclude = JsonNullable.<Map<String, Object>> of(exclude);
    }

    public PermissionConditions include(Map<String, Object> include) {
        this.include = JsonNullable.<Map<String, Object>> of(include);

        return this;
    }

    public PermissionConditions putincludeItem(String key, Object includeItem) {
        if (this.include == null || !this.include.isPresent()) {
            this.include = JsonNullable.<Map<String, Object>> of(null);
        }
        try {
            this.include.get().put(key, includeItem);
        } catch (java.util.NoSuchElementException e) {
            // this can never happen, as we make sure above that the value is present
        }
        return this;
    }

    /**
     * Include attributes with specific values for the permission
     *
     * @return include
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Include attributes with specific values for the permission")
    @JsonIgnore

    public Map<String, Object> getInclude() {
        return include.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<Map<String, Object>> getInclude_JsonNullable() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    public void setInclude_JsonNullable(JsonNullable<Map<String, Object>> include) {
        this.include = include;
    }

    public void setInclude(Map<String, Object> include) {
        this.include = JsonNullable.<Map<String, Object>> of(include);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PermissionConditions permissionConditions = (PermissionConditions) o;
        return equalsNullable(this.exclude, permissionConditions.exclude)
                && equalsNullable(this.include, permissionConditions.include);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(exclude), hashCodeNullable(include));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionConditions {\n");
        sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
