package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PolicyContextDevice;
import com.okta.sdk.resource.model.PolicyContextGroups;
import com.okta.sdk.resource.model.PolicyContextRisk;
import com.okta.sdk.resource.model.PolicyContextUser;
import com.okta.sdk.resource.model.PolicyContextZones;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PolicyContext
 */
@JsonPropertyOrder({ PolicyContext.JSON_PROPERTY_DEVICE, PolicyContext.JSON_PROPERTY_GROUPS,
        PolicyContext.JSON_PROPERTY_IP, PolicyContext.JSON_PROPERTY_RISK, PolicyContext.JSON_PROPERTY_USER,
        PolicyContext.JSON_PROPERTY_ZONES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PolicyContext implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DEVICE = "device";
    private PolicyContextDevice device;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private PolicyContextGroups groups;

    public static final String JSON_PROPERTY_IP = "ip";
    private String ip;

    public static final String JSON_PROPERTY_RISK = "risk";
    private PolicyContextRisk risk;

    public static final String JSON_PROPERTY_USER = "user";
    private PolicyContextUser user;

    public static final String JSON_PROPERTY_ZONES = "zones";
    private PolicyContextZones zones;

    public PolicyContext() {
    }

    public PolicyContext device(PolicyContextDevice device) {

        this.device = device;
        return this;
    }

    /**
     * Get device
     *
     * @return device
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyContextDevice getDevice() {
        return device;
    }

    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDevice(PolicyContextDevice device) {
        this.device = device;
    }

    public PolicyContext groups(PolicyContextGroups groups) {

        this.groups = groups;
        return this;
    }

    /**
     * Get groups
     *
     * @return groups
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public PolicyContextGroups getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setGroups(PolicyContextGroups groups) {
        this.groups = groups;
    }

    public PolicyContext ip(String ip) {

        this.ip = ip;
        return this;
    }

    /**
     * The network rule condition, zone, or IP address
     *
     * @return ip
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The network rule condition, zone, or IP address")
    @JsonProperty(JSON_PROPERTY_IP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIp() {
        return ip;
    }

    @JsonProperty(JSON_PROPERTY_IP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIp(String ip) {
        this.ip = ip;
    }

    public PolicyContext risk(PolicyContextRisk risk) {

        this.risk = risk;
        return this;
    }

    /**
     * Get risk
     *
     * @return risk
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RISK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyContextRisk getRisk() {
        return risk;
    }

    @JsonProperty(JSON_PROPERTY_RISK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRisk(PolicyContextRisk risk) {
        this.risk = risk;
    }

    public PolicyContext user(PolicyContextUser user) {

        this.user = user;
        return this;
    }

    /**
     * Get user
     *
     * @return user
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public PolicyContextUser getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUser(PolicyContextUser user) {
        this.user = user;
    }

    public PolicyContext zones(PolicyContextZones zones) {

        this.zones = zones;
        return this;
    }

    /**
     * Get zones
     *
     * @return zones
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ZONES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyContextZones getZones() {
        return zones;
    }

    @JsonProperty(JSON_PROPERTY_ZONES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setZones(PolicyContextZones zones) {
        this.zones = zones;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PolicyContext policyContext = (PolicyContext) o;
        return Objects.equals(this.device, policyContext.device) && Objects.equals(this.groups, policyContext.groups)
                && Objects.equals(this.ip, policyContext.ip) && Objects.equals(this.risk, policyContext.risk)
                && Objects.equals(this.user, policyContext.user) && Objects.equals(this.zones, policyContext.zones);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(device, groups, ip, risk, user, zones);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyContext {\n");
        sb.append("    device: ").append(toIndentedString(device)).append("\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
        sb.append("    risk: ").append(toIndentedString(risk)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("    zones: ").append(toIndentedString(zones)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
