package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PostAuthSessionFailureActionsObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * This object contains a &#x60;failureActions&#x60; array that defines the specific action to take when post auth
 * session evaluation detects a failure.
 */
@ApiModel(description = "This object contains a `failureActions` array that defines the specific action to take when post auth session evaluation detects a failure.")
@JsonPropertyOrder({ PostAuthSessionPolicyRuleAllOfActionsPostAuthSession.JSON_PROPERTY_FAILURE_ACTIONS })
@JsonTypeName("PostAuthSessionPolicyRule_allOf_actions_postAuthSession")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PostAuthSessionPolicyRuleAllOfActionsPostAuthSession implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FAILURE_ACTIONS = "failureActions";
    private List<PostAuthSessionFailureActionsObject> failureActions = null;

    public PostAuthSessionPolicyRuleAllOfActionsPostAuthSession() {
    }

    public PostAuthSessionPolicyRuleAllOfActionsPostAuthSession failureActions(
            List<PostAuthSessionFailureActionsObject> failureActions) {

        this.failureActions = failureActions;
        return this;
    }

    public PostAuthSessionPolicyRuleAllOfActionsPostAuthSession addfailureActionsItem(
            PostAuthSessionFailureActionsObject failureActionsItem) {
        if (this.failureActions == null) {
            this.failureActions = new ArrayList<>();
        }
        this.failureActions.add(failureActionsItem);
        return this;
    }

    /**
     * An array of objects that define the action. It can be empty or contain two &#x60;action&#x60; value pairs.
     *
     * @return failureActions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An array of objects that define the action. It can be empty or contain two `action` value pairs.")
    @JsonProperty(JSON_PROPERTY_FAILURE_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<PostAuthSessionFailureActionsObject> getFailureActions() {
        return failureActions;
    }

    @JsonProperty(JSON_PROPERTY_FAILURE_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFailureActions(List<PostAuthSessionFailureActionsObject> failureActions) {
        this.failureActions = failureActions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PostAuthSessionPolicyRuleAllOfActionsPostAuthSession postAuthSessionPolicyRuleAllOfActionsPostAuthSession = (PostAuthSessionPolicyRuleAllOfActionsPostAuthSession) o;
        return Objects.equals(this.failureActions, postAuthSessionPolicyRuleAllOfActionsPostAuthSession.failureActions);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(failureActions);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostAuthSessionPolicyRuleAllOfActionsPostAuthSession {\n");
        sb.append("    failureActions: ").append(toIndentedString(failureActions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
