package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProtocolAlgorithmTypeSignatureScope;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ProtocolAlgorithmTypeSignature
 */
@JsonPropertyOrder({ ProtocolAlgorithmTypeSignature.JSON_PROPERTY_ALGORITHM,
        ProtocolAlgorithmTypeSignature.JSON_PROPERTY_SCOPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ProtocolAlgorithmTypeSignature implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private String algorithm;

    public static final String JSON_PROPERTY_SCOPE = "scope";
    private ProtocolAlgorithmTypeSignatureScope scope;

    public ProtocolAlgorithmTypeSignature() {
    }

    public ProtocolAlgorithmTypeSignature algorithm(String algorithm) {

        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get algorithm
     *
     * @return algorithm
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAlgorithm() {
        return algorithm;
    }

    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public ProtocolAlgorithmTypeSignature scope(ProtocolAlgorithmTypeSignatureScope scope) {

        this.scope = scope;
        return this;
    }

    /**
     * Get scope
     *
     * @return scope
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolAlgorithmTypeSignatureScope getScope() {
        return scope;
    }

    @JsonProperty(JSON_PROPERTY_SCOPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScope(ProtocolAlgorithmTypeSignatureScope scope) {
        this.scope = scope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProtocolAlgorithmTypeSignature protocolAlgorithmTypeSignature = (ProtocolAlgorithmTypeSignature) o;
        return Objects.equals(this.algorithm, protocolAlgorithmTypeSignature.algorithm)
                && Objects.equals(this.scope, protocolAlgorithmTypeSignature.scope);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(algorithm, scope);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolAlgorithmTypeSignature {\n");
        sb.append("    algorithm: ").append(toIndentedString(algorithm)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
