package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthCredentials;
import com.okta.sdk.resource.model.OAuthEndpoints;
import com.okta.sdk.resource.model.OidcAlgorithms;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Protocol settings for authentication using the [OpenID Connect
 * Protocol](http://openid.net/specs/openid-connect-core-1_0.html#CodeFlowAuth)
 */
@ApiModel(description = "Protocol settings for authentication using the [OpenID Connect Protocol](http://openid.net/specs/openid-connect-core-1_0.html#CodeFlowAuth)")
@JsonPropertyOrder({ ProtocolOidc.JSON_PROPERTY_ALGORITHMS, ProtocolOidc.JSON_PROPERTY_CREDENTIALS,
        ProtocolOidc.JSON_PROPERTY_ENDPOINTS, ProtocolOidc.JSON_PROPERTY_SCOPES, ProtocolOidc.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ProtocolOidc implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
    private OidcAlgorithms algorithms;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private OAuthCredentials credentials;

    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private OAuthEndpoints endpoints;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;

    /**
     * OpenID Connect Authorization Code flow
     */
    public enum TypeEnum {
        OIDC(String.valueOf("OIDC")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ProtocolOidc() {
    }

    public ProtocolOidc algorithms(OidcAlgorithms algorithms) {

        this.algorithms = algorithms;
        return this;
    }

    /**
     * Get algorithms
     *
     * @return algorithms
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALGORITHMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OidcAlgorithms getAlgorithms() {
        return algorithms;
    }

    @JsonProperty(JSON_PROPERTY_ALGORITHMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithms(OidcAlgorithms algorithms) {
        this.algorithms = algorithms;
    }

    public ProtocolOidc credentials(OAuthCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(OAuthCredentials credentials) {
        this.credentials = credentials;
    }

    public ProtocolOidc endpoints(OAuthEndpoints endpoints) {

        this.endpoints = endpoints;
        return this;
    }

    /**
     * Get endpoints
     *
     * @return endpoints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ENDPOINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthEndpoints getEndpoints() {
        return endpoints;
    }

    @JsonProperty(JSON_PROPERTY_ENDPOINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(OAuthEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public ProtocolOidc scopes(List<String> scopes) {

        this.scopes = scopes;
        return this;
    }

    public ProtocolOidc addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    /**
     * OpenID Connect and IdP-defined permission bundles to request delegated access from the User &gt; **Note:** The
     * [Identity Provider
     * type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path&#x3D;type&amp;t&#x3D;request)
     * table lists the scopes that are supported for each Identity Provider.
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "OpenID Connect and IdP-defined permission bundles to request delegated access from the User > **Note:** The [Identity Provider type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=type&t=request) table lists the scopes that are supported for each Identity Provider.")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getScopes() {
        return scopes;
    }

    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ProtocolOidc type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * OpenID Connect Authorization Code flow
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "OpenID Connect Authorization Code flow")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProtocolOidc protocolOidc = (ProtocolOidc) o;
        return Objects.equals(this.algorithms, protocolOidc.algorithms)
                && Objects.equals(this.credentials, protocolOidc.credentials)
                && Objects.equals(this.endpoints, protocolOidc.endpoints)
                && Objects.equals(this.scopes, protocolOidc.scopes) && Objects.equals(this.type, protocolOidc.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(algorithms, credentials, endpoints, scopes, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolOidc {\n");
        sb.append("    algorithms: ").append(toIndentedString(algorithms)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    endpoints: ").append(toIndentedString(endpoints)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
