package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelfLifecycleAndAuthorize;
import com.okta.sdk.resource.model.ProvisioningConnectionResponseProfile;
import com.okta.sdk.resource.model.ProvisioningConnectionStatus;
import com.okta.sdk.resource.model.ProvisioningConnectionTokenAuthScheme;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ProvisioningConnectionResponse
 */
@JsonPropertyOrder({ ProvisioningConnectionResponse.JSON_PROPERTY_AUTH_SCHEME,
        ProvisioningConnectionResponse.JSON_PROPERTY_BASE_URL, ProvisioningConnectionResponse.JSON_PROPERTY_PROFILE,
        ProvisioningConnectionResponse.JSON_PROPERTY_STATUS, ProvisioningConnectionResponse.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ProvisioningConnectionResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTH_SCHEME = "authScheme";
    private ProvisioningConnectionTokenAuthScheme authScheme;

    public static final String JSON_PROPERTY_BASE_URL = "baseUrl";
    private String baseUrl;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private ProvisioningConnectionResponseProfile profile;

    public static final String JSON_PROPERTY_STATUS = "status";
    private ProvisioningConnectionStatus status = ProvisioningConnectionStatus.DISABLED;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelfLifecycleAndAuthorize links;

    public ProvisioningConnectionResponse() {
    }

    public ProvisioningConnectionResponse authScheme(ProvisioningConnectionTokenAuthScheme authScheme) {

        this.authScheme = authScheme;
        return this;
    }

    /**
     * Get authScheme
     *
     * @return authScheme
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProvisioningConnectionTokenAuthScheme getAuthScheme() {
        return authScheme;
    }

    @JsonProperty(JSON_PROPERTY_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthScheme(ProvisioningConnectionTokenAuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public ProvisioningConnectionResponse baseUrl(String baseUrl) {

        this.baseUrl = baseUrl;
        return this;
    }

    /**
     * Base URL
     *
     * @return baseUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Base URL")
    @JsonProperty(JSON_PROPERTY_BASE_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getBaseUrl() {
        return baseUrl;
    }

    @JsonProperty(JSON_PROPERTY_BASE_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ProvisioningConnectionResponse profile(ProvisioningConnectionResponseProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ProvisioningConnectionResponseProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setProfile(ProvisioningConnectionResponseProfile profile) {
        this.profile = profile;
    }

    public ProvisioningConnectionResponse status(ProvisioningConnectionStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ProvisioningConnectionStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setStatus(ProvisioningConnectionStatus status) {
        this.status = status;
    }

    public ProvisioningConnectionResponse links(LinksSelfLifecycleAndAuthorize links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelfLifecycleAndAuthorize getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelfLifecycleAndAuthorize links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisioningConnectionResponse provisioningConnectionResponse = (ProvisioningConnectionResponse) o;
        return Objects.equals(this.authScheme, provisioningConnectionResponse.authScheme)
                && Objects.equals(this.baseUrl, provisioningConnectionResponse.baseUrl)
                && Objects.equals(this.profile, provisioningConnectionResponse.profile)
                && Objects.equals(this.status, provisioningConnectionResponse.status)
                && Objects.equals(this.links, provisioningConnectionResponse.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authScheme, baseUrl, profile, status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProvisioningConnectionResponse {\n");
        sb.append("    authScheme: ").append(toIndentedString(authScheme)).append("\n");
        sb.append("    baseUrl: ").append(toIndentedString(baseUrl)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
