package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GovernanceSourceType;
import com.okta.sdk.resource.model.RoleGovernanceSourceLinks;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * User Role Governance Source
 */
@ApiModel(description = "User Role Governance Source")
@JsonPropertyOrder({ RoleGovernanceSource.JSON_PROPERTY_BUNDLE_ID, RoleGovernanceSource.JSON_PROPERTY_EXPIRATION_DATE,
        RoleGovernanceSource.JSON_PROPERTY_GRANT_ID, RoleGovernanceSource.JSON_PROPERTY_TYPE,
        RoleGovernanceSource.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleGovernanceSource implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BUNDLE_ID = "bundleId";
    private String bundleId;

    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
    private OffsetDateTime expirationDate;

    public static final String JSON_PROPERTY_GRANT_ID = "grantId";
    private String grantId;

    public static final String JSON_PROPERTY_TYPE = "type";
    private GovernanceSourceType type;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private RoleGovernanceSourceLinks links;

    public RoleGovernanceSource() {
    }

    /*
     * @JsonCreator public RoleGovernanceSource(
     *
     * @JsonProperty(JSON_PROPERTY_BUNDLE_ID) String bundleId,
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE) OffsetDateTime expirationDate,
     *
     * @JsonProperty(JSON_PROPERTY_GRANT_ID) String grantId ) { this(); this.bundleId = bundleId; this.expirationDate =
     * expirationDate; this.grantId = grantId; }
     */

    /**
     * &#x60;id&#x60; of the entitlement bundle
     *
     * @return bundleId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "`id` of the entitlement bundle")
    @JsonProperty(JSON_PROPERTY_BUNDLE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getBundleId() {
        return bundleId;
    }

    /**
     * The expiration date of the entitlement bundle
     *
     * @return expirationDate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The expiration date of the entitlement bundle")
    @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpirationDate() {
        return expirationDate;
    }

    /**
     * &#x60;id&#x60; of the grant
     *
     * @return grantId
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "`id` of the grant")
    @JsonProperty(JSON_PROPERTY_GRANT_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getGrantId() {
        return grantId;
    }

    public RoleGovernanceSource type(GovernanceSourceType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public GovernanceSourceType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(GovernanceSourceType type) {
        this.type = type;
    }

    public RoleGovernanceSource links(RoleGovernanceSourceLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RoleGovernanceSourceLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(RoleGovernanceSourceLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleGovernanceSource roleGovernanceSource = (RoleGovernanceSource) o;
        return Objects.equals(this.bundleId, roleGovernanceSource.bundleId)
                && Objects.equals(this.expirationDate, roleGovernanceSource.expirationDate)
                && Objects.equals(this.grantId, roleGovernanceSource.grantId)
                && Objects.equals(this.type, roleGovernanceSource.type)
                && Objects.equals(this.links, roleGovernanceSource.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bundleId, expirationDate, grantId, type, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleGovernanceSource {\n");
        sb.append("    bundleId: ").append(toIndentedString(bundleId)).append("\n");
        sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
        sb.append("    grantId: ").append(toIndentedString(grantId)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
