package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Standard role type
 */
public enum RoleType {

    ACCESS_CERTIFICATIONS_ADMIN("ACCESS_CERTIFICATIONS_ADMIN"),

    ACCESS_REQUESTS_ADMIN("ACCESS_REQUESTS_ADMIN"),

    API_ACCESS_MANAGEMENT_ADMIN("API_ACCESS_MANAGEMENT_ADMIN"),

    API_ADMIN("API_ADMIN"),

    APP_ADMIN("APP_ADMIN"),

    CUSTOM("CUSTOM"),

    GROUP_MEMBERSHIP_ADMIN("GROUP_MEMBERSHIP_ADMIN"),

    HELP_DESK_ADMIN("HELP_DESK_ADMIN"),

    MOBILE_ADMIN("MOBILE_ADMIN"),

    ORG_ADMIN("ORG_ADMIN"),

    READ_ONLY_ADMIN("READ_ONLY_ADMIN"),

    REPORT_ADMIN("REPORT_ADMIN"),

    SUPER_ADMIN("SUPER_ADMIN"),

    USER_ADMIN("USER_ADMIN"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    RoleType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static RoleType fromValue(String value) {
        for (RoleType b : RoleType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
