package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertion;
import com.okta.sdk.resource.model.SAMLPayLoadDataContext;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAMLPayLoadData
 */
@JsonPropertyOrder({ SAMLPayLoadData.JSON_PROPERTY_CONTEXT, SAMLPayLoadData.JSON_PROPERTY_ASSERTION })
@JsonTypeName("SAMLPayLoad_data")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadData implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONTEXT = "context";
    private SAMLPayLoadDataContext context;

    public static final String JSON_PROPERTY_ASSERTION = "assertion";
    private SAMLPayLoadDataAssertion assertion;

    public SAMLPayLoadData() {
    }

    public SAMLPayLoadData context(SAMLPayLoadDataContext context) {

        this.context = context;
        return this;
    }

    /**
     * Get context
     *
     * @return context
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataContext getContext() {
        return context;
    }

    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContext(SAMLPayLoadDataContext context) {
        this.context = context;
    }

    public SAMLPayLoadData assertion(SAMLPayLoadDataAssertion assertion) {

        this.assertion = assertion;
        return this;
    }

    /**
     * Get assertion
     *
     * @return assertion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASSERTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataAssertion getAssertion() {
        return assertion;
    }

    @JsonProperty(JSON_PROPERTY_ASSERTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssertion(SAMLPayLoadDataAssertion assertion) {
        this.assertion = assertion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadData saMLPayLoadData = (SAMLPayLoadData) o;
        return Objects.equals(this.context, saMLPayLoadData.context)
                && Objects.equals(this.assertion, saMLPayLoadData.assertion);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(context, assertion);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadData {\n");
        sb.append("    context: ").append(toIndentedString(context)).append("\n");
        sb.append("    assertion: ").append(toIndentedString(assertion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
