package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAMLPayLoadDataAssertionSubjectConfirmationData
 */
@JsonPropertyOrder({ SAMLPayLoadDataAssertionSubjectConfirmationData.JSON_PROPERTY_RECIPIENT })
@JsonTypeName("SAMLPayLoad_data_assertion_subject_confirmation_data")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadDataAssertionSubjectConfirmationData implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_RECIPIENT = "recipient";
    private String recipient;

    public SAMLPayLoadDataAssertionSubjectConfirmationData() {
    }

    public SAMLPayLoadDataAssertionSubjectConfirmationData recipient(String recipient) {

        this.recipient = recipient;
        return this;
    }

    /**
     * The token endpoint URL of the authorization server
     *
     * @return recipient
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "http://www.example.com:7070/saml/sso", value = "The token endpoint URL of the authorization server")
    @JsonProperty(JSON_PROPERTY_RECIPIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRecipient() {
        return recipient;
    }

    @JsonProperty(JSON_PROPERTY_RECIPIENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertionSubjectConfirmationData saMLPayLoadDataAssertionSubjectConfirmationData = (SAMLPayLoadDataAssertionSubjectConfirmationData) o;
        return Objects.equals(this.recipient, saMLPayLoadDataAssertionSubjectConfirmationData.recipient);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(recipient);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertionSubjectConfirmationData {\n");
        sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
