package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationLicensing;
import com.okta.sdk.resource.model.ApplicationLifecycleStatus;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.SalesforceApplicationSettings;
import com.okta.sdk.resource.model.SchemeApplicationCredentials;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Schema for the Salesforce app (key name: &#x60;salesforce&#x60;) To create a Salesforce app, use the [Create an
 * Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication)
 * request with the following parameters in the request body. &gt; **Note:** The Salesforce app only supports
 * &#x60;BROWSER_PLUGIN&#x60;, &#x60;BOOKMARK&#x60;, and &#x60;SAML_2_0&#x60; sign-on modes.
 */
@ApiModel(description = "Schema for the Salesforce app (key name: `salesforce`)  To create a Salesforce app, use the [Create an Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication) request with the following parameters in the request body. > **Note:** The Salesforce app only supports `BROWSER_PLUGIN`, `BOOKMARK`, and `SAML_2_0` sign-on modes. ")
@JsonPropertyOrder({ SalesforceApplication.JSON_PROPERTY_ACCESSIBILITY, SalesforceApplication.JSON_PROPERTY_CREDENTIALS,
        SalesforceApplication.JSON_PROPERTY_LABEL, SalesforceApplication.JSON_PROPERTY_LICENSING,
        SalesforceApplication.JSON_PROPERTY_NAME, SalesforceApplication.JSON_PROPERTY_PROFILE,
        SalesforceApplication.JSON_PROPERTY_SIGN_ON_MODE, SalesforceApplication.JSON_PROPERTY_STATUS,
        SalesforceApplication.JSON_PROPERTY_VISIBILITY, SalesforceApplication.JSON_PROPERTY_SETTINGS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SalesforceApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACCESSIBILITY = "accessibility";
    private ApplicationAccessibility accessibility;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private SchemeApplicationCredentials credentials;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_LICENSING = "licensing";
    private ApplicationLicensing licensing;

    /**
     * Gets or Sets name
     */
    public enum NameEnum {
        SALESFORCE(String.valueOf("salesforce")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    /**
     * Gets or Sets signOnMode
     */
    public enum SignOnModeEnum {
        BROWSER_PLUGIN(String.valueOf("BROWSER_PLUGIN")),

        BOOKMARK(String.valueOf("BOOKMARK")),

        SAML_2_0(String.valueOf("SAML_2_0")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        SignOnModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static SignOnModeEnum fromValue(String value) {
            for (SignOnModeEnum b : SignOnModeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
    private SignOnModeEnum signOnMode;

    public static final String JSON_PROPERTY_STATUS = "status";
    private ApplicationLifecycleStatus status;

    public static final String JSON_PROPERTY_VISIBILITY = "visibility";
    private ApplicationVisibility visibility;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private SalesforceApplicationSettings settings;

    public SalesforceApplication() {
    }

    public SalesforceApplication accessibility(ApplicationAccessibility accessibility) {

        this.accessibility = accessibility;
        return this;
    }

    /**
     * Get accessibility
     *
     * @return accessibility
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACCESSIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationAccessibility getAccessibility() {
        return accessibility;
    }

    @JsonProperty(JSON_PROPERTY_ACCESSIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
    }

    public SalesforceApplication credentials(SchemeApplicationCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SchemeApplicationCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    public SalesforceApplication label(String label) {

        this.label = label;
        return this;
    }

    /**
     * User-defined display name for app
     *
     * @return label
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "User-defined display name for app")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public SalesforceApplication licensing(ApplicationLicensing licensing) {

        this.licensing = licensing;
        return this;
    }

    /**
     * Get licensing
     *
     * @return licensing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LICENSING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLicensing getLicensing() {
        return licensing;
    }

    @JsonProperty(JSON_PROPERTY_LICENSING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLicensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
    }

    public SalesforceApplication name(NameEnum name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "salesforce", required = true, value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public NameEnum getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(NameEnum name) {
        this.name = name;
    }

    public SalesforceApplication profile(Map<String, Object> profile) {

        this.profile = profile;
        return this;
    }

    public SalesforceApplication putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to
     * OAuth 2.0 client apps)
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to OAuth 2.0 client apps)")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public SalesforceApplication signOnMode(SignOnModeEnum signOnMode) {

        this.signOnMode = signOnMode;
        return this;
    }

    /**
     * Get signOnMode
     *
     * @return signOnMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "BROWSER_PLUGIN", value = "")
    @JsonProperty(JSON_PROPERTY_SIGN_ON_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SignOnModeEnum getSignOnMode() {
        return signOnMode;
    }

    @JsonProperty(JSON_PROPERTY_SIGN_ON_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignOnMode(SignOnModeEnum signOnMode) {
        this.signOnMode = signOnMode;
    }

    public SalesforceApplication status(ApplicationLifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ApplicationLifecycleStatus status) {
        this.status = status;
    }

    public SalesforceApplication visibility(ApplicationVisibility visibility) {

        this.visibility = visibility;
        return this;
    }

    /**
     * Get visibility
     *
     * @return visibility
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VISIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationVisibility getVisibility() {
        return visibility;
    }

    @JsonProperty(JSON_PROPERTY_VISIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVisibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
    }

    public SalesforceApplication settings(SalesforceApplicationSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SalesforceApplicationSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSettings(SalesforceApplicationSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SalesforceApplication salesforceApplication = (SalesforceApplication) o;
        return Objects.equals(this.accessibility, salesforceApplication.accessibility)
                && Objects.equals(this.credentials, salesforceApplication.credentials)
                && Objects.equals(this.label, salesforceApplication.label)
                && Objects.equals(this.licensing, salesforceApplication.licensing)
                && Objects.equals(this.name, salesforceApplication.name)
                && Objects.equals(this.profile, salesforceApplication.profile)
                && Objects.equals(this.signOnMode, salesforceApplication.signOnMode)
                && Objects.equals(this.status, salesforceApplication.status)
                && Objects.equals(this.visibility, salesforceApplication.visibility)
                && Objects.equals(this.settings, salesforceApplication.settings);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessibility, credentials, label, licensing, name, profile, signOnMode, status, visibility,
                settings);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesforceApplication {\n");
        sb.append("    accessibility: ").append(toIndentedString(accessibility)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    licensing: ").append(toIndentedString(licensing)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    signOnMode: ").append(toIndentedString(signOnMode)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
