package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SamlAcsInner;
import com.okta.sdk.resource.model.SamlClaimsInner;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAML configuration details
 */
@ApiModel(description = "SAML configuration details")
@JsonPropertyOrder({ Saml.JSON_PROPERTY_ACS, Saml.JSON_PROPERTY_CLAIMS, Saml.JSON_PROPERTY_DOC,
        Saml.JSON_PROPERTY_ENTITY_ID, Saml.JSON_PROPERTY_GROUPS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class Saml implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACS = "acs";
    private List<SamlAcsInner> acs = new ArrayList<>();

    public static final String JSON_PROPERTY_CLAIMS = "claims";
    private List<SamlClaimsInner> claims = null;

    public static final String JSON_PROPERTY_DOC = "doc";
    private URI doc;

    public static final String JSON_PROPERTY_ENTITY_ID = "entityId";
    private String entityId;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private List<String> groups = null;

    public Saml() {
    }

    public Saml acs(List<SamlAcsInner> acs) {

        this.acs = acs;
        return this;
    }

    public Saml addacsItem(SamlAcsInner acsItem) {
        if (this.acs == null) {
            this.acs = new ArrayList<>();
        }
        this.acs.add(acsItem);
        return this;
    }

    /**
     * List of Assertion Consumer Service (ACS) URLs. The default ACS URL is required and is indicated by a null
     * &#x60;index&#x60; value. You can use the org-level variables you defined in the &#x60;config&#x60; array in the
     * URL. For example: &#x60;https://${org.subdomain}.example.com/saml/login&#x60;
     *
     * @return acs
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "List of Assertion Consumer Service (ACS) URLs. The default ACS URL is required and is indicated by a null `index` value. You can use the org-level variables you defined in the `config` array in the URL. For example: `https://${org.subdomain}.example.com/saml/login`")
    @JsonProperty(JSON_PROPERTY_ACS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<SamlAcsInner> getAcs() {
        return acs;
    }

    @JsonProperty(JSON_PROPERTY_ACS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAcs(List<SamlAcsInner> acs) {
        this.acs = acs;
    }

    public Saml claims(List<SamlClaimsInner> claims) {

        this.claims = claims;
        return this;
    }

    public Saml addclaimsItem(SamlClaimsInner claimsItem) {
        if (this.claims == null) {
            this.claims = new ArrayList<>();
        }
        this.claims.add(claimsItem);
        return this;
    }

    /**
     * Attribute statements to appear in the Okta SAML assertion
     *
     * @return claims
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Attribute statements to appear in the Okta SAML assertion")
    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SamlClaimsInner> getClaims() {
        return claims;
    }

    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClaims(List<SamlClaimsInner> claims) {
        this.claims = claims;
    }

    public Saml doc(URI doc) {

        this.doc = doc;
        return this;
    }

    /**
     * The URL to your customer-facing instructions for configuring your SAML integration. See [Customer configuration
     * document
     * guidelines](https://developer.okta.com/docs/guides/submit-app-prereq/main/#customer-configuration-document-guidelines).
     *
     * @return doc
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://example.com/strawberry/help/samlSetup", required = true, value = "The URL to your customer-facing instructions for configuring your SAML integration. See [Customer configuration document guidelines](https://developer.okta.com/docs/guides/submit-app-prereq/main/#customer-configuration-document-guidelines).")
    @JsonProperty(JSON_PROPERTY_DOC)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public URI getDoc() {
        return doc;
    }

    @JsonProperty(JSON_PROPERTY_DOC)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDoc(URI doc) {
        this.doc = doc;
    }

    public Saml entityId(String entityId) {

        this.entityId = entityId;
        return this;
    }

    /**
     * Globally unique name for your SAML entity. For instance, your Identity Provider (IdP) or Service Provider (SP)
     * URL.
     *
     * @return entityId
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://${org.subdomain}.example.com", required = true, value = "Globally unique name for your SAML entity. For instance, your Identity Provider (IdP) or Service Provider (SP) URL.")
    @JsonProperty(JSON_PROPERTY_ENTITY_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getEntityId() {
        return entityId;
    }

    @JsonProperty(JSON_PROPERTY_ENTITY_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public Saml groups(List<String> groups) {

        this.groups = groups;
        return this;
    }

    public Saml addgroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    /**
     * Defines the group attribute names for the SAML assertion statement. Okta inserts the list of Okta user groups
     * into the attribute names in the statement.
     *
     * @return groups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Defines the group attribute names for the SAML assertion statement. Okta inserts the list of Okta user groups into the attribute names in the statement.")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Saml saml = (Saml) o;
        return Objects.equals(this.acs, saml.acs) && Objects.equals(this.claims, saml.claims)
                && Objects.equals(this.doc, saml.doc) && Objects.equals(this.entityId, saml.entityId)
                && Objects.equals(this.groups, saml.groups);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(acs, claims, doc, entityId, groups);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Saml {\n");
        sb.append("    acs: ").append(toIndentedString(acs)).append("\n");
        sb.append("    claims: ").append(toIndentedString(claims)).append("\n");
        sb.append("    doc: ").append(toIndentedString(doc)).append("\n");
        sb.append("    entityId: ").append(toIndentedString(entityId)).append("\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
