package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SamlResponseSignatureAlgorithm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Algorithm settings for verifying &#x60;&lt;SAMLResponse&gt;&#x60; messages and &#x60;&lt;Assertion&gt;&#x60; elements
 * from the IdP
 */
@ApiModel(description = "Algorithm settings for verifying `<SAMLResponse>` messages and `<Assertion>` elements from the IdP")
@JsonPropertyOrder({ SamlResponseAlgorithm.JSON_PROPERTY_SIGNATURE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SamlResponseAlgorithm implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private SamlResponseSignatureAlgorithm signature;

    public SamlResponseAlgorithm() {
    }

    public SamlResponseAlgorithm signature(SamlResponseSignatureAlgorithm signature) {

        this.signature = signature;
        return this;
    }

    /**
     * Get signature
     *
     * @return signature
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGNATURE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SamlResponseSignatureAlgorithm getSignature() {
        return signature;
    }

    @JsonProperty(JSON_PROPERTY_SIGNATURE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignature(SamlResponseSignatureAlgorithm signature) {
        this.signature = signature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlResponseAlgorithm samlResponseAlgorithm = (SamlResponseAlgorithm) o;
        return Objects.equals(this.signature, samlResponseAlgorithm.signature);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(signature);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlResponseAlgorithm {\n");
        sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
