package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SecurityEventsProviderRequestSettings;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The request schema for creating or updating a Security Events Provider. The &#x60;settings&#x60; must match one of
 * the schemas.
 */
@ApiModel(description = "The request schema for creating or updating a Security Events Provider. The `settings` must match one of the schemas.")
@JsonPropertyOrder({ SecurityEventsProviderRequest.JSON_PROPERTY_NAME,
        SecurityEventsProviderRequest.JSON_PROPERTY_SETTINGS, SecurityEventsProviderRequest.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SecurityEventsProviderRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private SecurityEventsProviderRequestSettings settings;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public SecurityEventsProviderRequest() {
    }

    public SecurityEventsProviderRequest name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The name of the Security Events Provider instance
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "Target SSF Provider", required = true, value = "The name of the Security Events Provider instance")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SecurityEventsProviderRequest settings(SecurityEventsProviderRequestSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SecurityEventsProviderRequestSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSettings(SecurityEventsProviderRequestSettings settings) {
        this.settings = settings;
    }

    public SecurityEventsProviderRequest type(String type) {

        this.type = type;
        return this;
    }

    /**
     * The application type of the Security Events Provider
     *
     * @return type
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "okta", required = true, value = "The application type of the Security Events Provider")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderRequest securityEventsProviderRequest = (SecurityEventsProviderRequest) o;
        return Objects.equals(this.name, securityEventsProviderRequest.name)
                && Objects.equals(this.settings, securityEventsProviderRequest.settings)
                && Objects.equals(this.type, securityEventsProviderRequest.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, settings, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderRequest {\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
