package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.StreamConfigurationDelivery;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * StreamConfigurationCreateRequest
 */
@JsonPropertyOrder({ StreamConfigurationCreateRequest.JSON_PROPERTY_DELIVERY,
        StreamConfigurationCreateRequest.JSON_PROPERTY_EVENTS_REQUESTED,
        StreamConfigurationCreateRequest.JSON_PROPERTY_FORMAT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class StreamConfigurationCreateRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DELIVERY = "delivery";
    private StreamConfigurationDelivery delivery;

    public static final String JSON_PROPERTY_EVENTS_REQUESTED = "events_requested";
    private List<URI> eventsRequested = new ArrayList<>();

    /**
     * The Subject Identifier format expected for any SET transmitted.
     */
    public enum FormatEnum {
        ISS_SUB(String.valueOf("iss_sub")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        FormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FormatEnum fromValue(String value) {
            for (FormatEnum b : FormatEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FORMAT = "format";
    private FormatEnum format;

    public StreamConfigurationCreateRequest() {
    }

    public StreamConfigurationCreateRequest delivery(StreamConfigurationDelivery delivery) {

        this.delivery = delivery;
        return this;
    }

    /**
     * Get delivery
     *
     * @return delivery
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_DELIVERY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public StreamConfigurationDelivery getDelivery() {
        return delivery;
    }

    @JsonProperty(JSON_PROPERTY_DELIVERY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDelivery(StreamConfigurationDelivery delivery) {
        this.delivery = delivery;
    }

    public StreamConfigurationCreateRequest eventsRequested(List<URI> eventsRequested) {

        this.eventsRequested = eventsRequested;
        return this;
    }

    public StreamConfigurationCreateRequest addeventsRequestedItem(URI eventsRequestedItem) {
        if (this.eventsRequested == null) {
            this.eventsRequested = new ArrayList<>();
        }
        this.eventsRequested.add(eventsRequestedItem);
        return this;
    }

    /**
     * The events (mapped by the array of event type URIs) that the receiver wants to receive
     *
     * @return eventsRequested
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "[\"https://schemas.openid.net/secevent/caep/event-type/session-revoked\",\"https://schemas.openid.net/secevent/caep/event-type/credential-change\"]", required = true, value = "The events (mapped by the array of event type URIs) that the receiver wants to receive")
    @JsonProperty(JSON_PROPERTY_EVENTS_REQUESTED)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<URI> getEventsRequested() {
        return eventsRequested;
    }

    @JsonProperty(JSON_PROPERTY_EVENTS_REQUESTED)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEventsRequested(List<URI> eventsRequested) {
        this.eventsRequested = eventsRequested;
    }

    public StreamConfigurationCreateRequest format(FormatEnum format) {

        this.format = format;
        return this;
    }

    /**
     * The Subject Identifier format expected for any SET transmitted.
     *
     * @return format
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The Subject Identifier format expected for any SET transmitted.")
    @JsonProperty(JSON_PROPERTY_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FormatEnum getFormat() {
        return format;
    }

    @JsonProperty(JSON_PROPERTY_FORMAT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StreamConfigurationCreateRequest streamConfigurationCreateRequest = (StreamConfigurationCreateRequest) o;
        return Objects.equals(this.delivery, streamConfigurationCreateRequest.delivery)
                && Objects.equals(this.eventsRequested, streamConfigurationCreateRequest.eventsRequested)
                && Objects.equals(this.format, streamConfigurationCreateRequest.format);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(delivery, eventsRequested, format);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StreamConfigurationCreateRequest {\n");
        sb.append("    delivery: ").append(toIndentedString(delivery)).append("\n");
        sb.append("    eventsRequested: ").append(toIndentedString(eventsRequested)).append("\n");
        sb.append("    format: ").append(toIndentedString(format)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
