package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.SupportedMethodsSettings;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The supported methods of an Authenticator
 */
@ApiModel(description = "The supported methods of an Authenticator")
@JsonPropertyOrder({ SupportedMethods.JSON_PROPERTY_SETTINGS, SupportedMethods.JSON_PROPERTY_STATUS,
        SupportedMethods.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SupportedMethods implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private SupportedMethodsSettings settings;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    /**
     * The type of authenticator method
     */
    public enum TypeEnum {
        PUSH(String.valueOf("push")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public SupportedMethods() {
    }

    public SupportedMethods settings(SupportedMethodsSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SupportedMethodsSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(SupportedMethodsSettings settings) {
        this.settings = settings;
    }

    public SupportedMethods status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public SupportedMethods type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * The type of authenticator method
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of authenticator method")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SupportedMethods supportedMethods = (SupportedMethods) o;
        return Objects.equals(this.settings, supportedMethods.settings)
                && Objects.equals(this.status, supportedMethods.status)
                && Objects.equals(this.type, supportedMethods.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(settings, status, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedMethods {\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
