package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.TelephonyResponseCommandsInner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TelephonyResponse
 */
@JsonPropertyOrder({ TelephonyResponse.JSON_PROPERTY_COMMANDS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TelephonyResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_COMMANDS = "commands";
    private List<TelephonyResponseCommandsInner> commands = null;

    public TelephonyResponse() {
    }

    public TelephonyResponse commands(List<TelephonyResponseCommandsInner> commands) {

        this.commands = commands;
        return this;
    }

    public TelephonyResponse addcommandsItem(TelephonyResponseCommandsInner commandsItem) {
        if (this.commands == null) {
            this.commands = new ArrayList<>();
        }
        this.commands.add(commandsItem);
        return this;
    }

    /**
     * The &#x60;commands&#x60; object specifies whether Okta accepts the end user&#39;s sign-in credentials as valid or
     * not. For the Telephony inline hook, you typically only return one &#x60;commands&#x60; object with one array
     * element in it.
     *
     * @return commands
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `commands` object specifies whether Okta accepts the end user's sign-in credentials as valid or not. For the Telephony inline hook, you typically only return one `commands` object with one array element in it.")
    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<TelephonyResponseCommandsInner> getCommands() {
        return commands;
    }

    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCommands(List<TelephonyResponseCommandsInner> commands) {
        this.commands = commands;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TelephonyResponse telephonyResponse = (TelephonyResponse) o;
        return Objects.equals(this.commands, telephonyResponse.commands);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(commands);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelephonyResponse {\n");
        sb.append("    commands: ").append(toIndentedString(commands)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
