package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TelephonyResponseCommandsInnerValueInner
 */
@JsonPropertyOrder({ TelephonyResponseCommandsInnerValueInner.JSON_PROPERTY_STATUS,
        TelephonyResponseCommandsInnerValueInner.JSON_PROPERTY_PROVIDER,
        TelephonyResponseCommandsInnerValueInner.JSON_PROPERTY_TRANSACTION_ID,
        TelephonyResponseCommandsInnerValueInner.JSON_PROPERTY_TRANSACTION_METADATA })
@JsonTypeName("TelephonyResponse_commands_inner_value_inner")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TelephonyResponseCommandsInnerValueInner implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Status of telephony callout
     */
    public enum StatusEnum {
        SUCCESSFUL(String.valueOf("SUCCESSFUL")),

        PENDING(String.valueOf("PENDING")),

        FAILED(String.valueOf("FAILED")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private String provider;

    public static final String JSON_PROPERTY_TRANSACTION_ID = "transactionId";
    private String transactionId;

    public static final String JSON_PROPERTY_TRANSACTION_METADATA = "transactionMetadata";
    private String transactionMetadata;

    public TelephonyResponseCommandsInnerValueInner() {
    }

    public TelephonyResponseCommandsInnerValueInner status(StatusEnum status) {

        this.status = status;
        return this;
    }

    /**
     * Status of telephony callout
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Status of telephony callout")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TelephonyResponseCommandsInnerValueInner provider(String provider) {

        this.provider = provider;
        return this;
    }

    /**
     * Telephony provider for sms/voice
     *
     * @return provider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Telephony provider for sms/voice")
    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getProvider() {
        return provider;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(String provider) {
        this.provider = provider;
    }

    public TelephonyResponseCommandsInnerValueInner transactionId(String transactionId) {

        this.transactionId = transactionId;
        return this;
    }

    /**
     * Transaction ID for sms/voice
     *
     * @return transactionId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Transaction ID for sms/voice")
    @JsonProperty(JSON_PROPERTY_TRANSACTION_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTransactionId() {
        return transactionId;
    }

    @JsonProperty(JSON_PROPERTY_TRANSACTION_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TelephonyResponseCommandsInnerValueInner transactionMetadata(String transactionMetadata) {

        this.transactionMetadata = transactionMetadata;
        return this;
    }

    /**
     * Any relevant metadata for the telephony transaction
     *
     * @return transactionMetadata
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Any relevant metadata for the telephony transaction")
    @JsonProperty(JSON_PROPERTY_TRANSACTION_METADATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTransactionMetadata() {
        return transactionMetadata;
    }

    @JsonProperty(JSON_PROPERTY_TRANSACTION_METADATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionMetadata(String transactionMetadata) {
        this.transactionMetadata = transactionMetadata;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TelephonyResponseCommandsInnerValueInner telephonyResponseCommandsInnerValueInner = (TelephonyResponseCommandsInnerValueInner) o;
        return Objects.equals(this.status, telephonyResponseCommandsInnerValueInner.status)
                && Objects.equals(this.provider, telephonyResponseCommandsInnerValueInner.provider)
                && Objects.equals(this.transactionId, telephonyResponseCommandsInnerValueInner.transactionId) && Objects
                        .equals(this.transactionMetadata, telephonyResponseCommandsInnerValueInner.transactionMetadata);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, provider, transactionId, transactionMetadata);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelephonyResponseCommandsInnerValueInner {\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
        sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
        sb.append("    transactionMetadata: ").append(toIndentedString(transactionMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
