package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelf;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ThreatInsightConfiguration
 */
@JsonPropertyOrder({ ThreatInsightConfiguration.JSON_PROPERTY_ACTION, ThreatInsightConfiguration.JSON_PROPERTY_CREATED,
        ThreatInsightConfiguration.JSON_PROPERTY_EXCLUDE_ZONES, ThreatInsightConfiguration.JSON_PROPERTY_LAST_UPDATED,
        ThreatInsightConfiguration.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ThreatInsightConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Specifies how Okta responds to authentication requests from suspicious IP addresses
     */
    public enum ActionEnum {
        NONE(String.valueOf("none")),

        AUDIT(String.valueOf("audit")),

        BLOCK(String.valueOf("block")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            for (ActionEnum b : ActionEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_ACTION = "action";
    private ActionEnum action;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_EXCLUDE_ZONES = "excludeZones";
    private List<String> excludeZones = null;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public ThreatInsightConfiguration() {
    }

    /*
     * @JsonCreator public ThreatInsightConfiguration(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created;
     * this.lastUpdated = lastUpdated; }
     */

    public ThreatInsightConfiguration action(ActionEnum action) {

        this.action = action;
        return this;
    }

    /**
     * Specifies how Okta responds to authentication requests from suspicious IP addresses
     *
     * @return action
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "none", required = true, value = "Specifies how Okta responds to authentication requests from suspicious IP addresses")
    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ActionEnum getAction() {
        return action;
    }

    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAction(ActionEnum action) {
        this.action = action;
    }

    /**
     * Timestamp when the ThreatInsight Configuration object was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2020-08-05T22:18:30.629Z", value = "Timestamp when the ThreatInsight Configuration object was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public ThreatInsightConfiguration excludeZones(List<String> excludeZones) {

        this.excludeZones = excludeZones;
        return this;
    }

    public ThreatInsightConfiguration addexcludeZonesItem(String excludeZonesItem) {
        if (this.excludeZones == null) {
            this.excludeZones = new ArrayList<>();
        }
        this.excludeZones.add(excludeZonesItem);
        return this;
    }

    /**
     * Accepts a list of [Network Zone](/openapi/okta-management/management/tag/NetworkZone/) IDs. IPs in the excluded
     * network zones aren&#39;t logged or blocked. This ensures that traffic from known, trusted IPs isn&#39;t
     * accidentally logged or blocked.
     *
     * @return excludeZones
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[]", value = "Accepts a list of [Network Zone](/openapi/okta-management/management/tag/NetworkZone/) IDs. IPs in the excluded network zones aren't logged or blocked. This ensures that traffic from known, trusted IPs isn't accidentally logged or blocked.")
    @JsonProperty(JSON_PROPERTY_EXCLUDE_ZONES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getExcludeZones() {
        return excludeZones;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE_ZONES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeZones(List<String> excludeZones) {
        this.excludeZones = excludeZones;
    }

    /**
     * Timestamp when the ThreatInsight Configuration object was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2020-09-08T20:53:20.882Z", value = "Timestamp when the ThreatInsight Configuration object was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public ThreatInsightConfiguration links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ThreatInsightConfiguration threatInsightConfiguration = (ThreatInsightConfiguration) o;
        return Objects.equals(this.action, threatInsightConfiguration.action)
                && Objects.equals(this.created, threatInsightConfiguration.created)
                && Objects.equals(this.excludeZones, threatInsightConfiguration.excludeZones)
                && Objects.equals(this.lastUpdated, threatInsightConfiguration.lastUpdated)
                && Objects.equals(this.links, threatInsightConfiguration.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(action, created, excludeZones, lastUpdated, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreatInsightConfiguration {\n");
        sb.append("    action: ").append(toIndentedString(action)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    excludeZones: ").append(toIndentedString(excludeZones)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
