package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * When an error object is returned, it causes Okta to return an OAuth 2.0 error to the requester of the token. In the
 * error response, the value of &#x60;error&#x60; is &#x60;server_error&#x60;, and the value of
 * &#x60;error_description&#x60; is the string that you supplied in the &#x60;errorSummary&#x60; property of the
 * &#x60;error&#x60; object that you returned.
 */
@ApiModel(description = "When an error object is returned, it causes Okta to return an OAuth 2.0 error to the requester of the token. In the error response, the value of `error` is `server_error`, and the value of `error_description` is the string that you supplied in the `errorSummary` property of the `error` object that you returned.")
@JsonPropertyOrder({ TokenHookResponseError.JSON_PROPERTY_ERROR_SUMMARY })
@JsonTypeName("TokenHookResponse_error")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TokenHookResponseError implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;

    public TokenHookResponseError() {
    }

    public TokenHookResponseError errorSummary(String errorSummary) {

        this.errorSummary = errorSummary;
        return this;
    }

    /**
     * Human-readable summary of the error. If the error object doesn&#39;t include the &#x60;errorSummary&#x60;
     * property defined, the following common default message is returned to the end user: &#x60;The callback service
     * returned an error&#x60;.
     *
     * @return errorSummary
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Human-readable summary of the error. If the error object doesn't include the `errorSummary` property defined, the following common default message is returned to the end user: `The callback service returned an error`.")
    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorSummary() {
        return errorSummary;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenHookResponseError tokenHookResponseError = (TokenHookResponseError) o;
        return Objects.equals(this.errorSummary, tokenHookResponseError.errorSummary);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorSummary);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenHookResponseError {\n");
        sb.append("    errorSummary: ").append(toIndentedString(errorSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
