package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The authorization server&#39;s issuer identifier
 */
@ApiModel(description = "The authorization server's issuer identifier")
@JsonPropertyOrder({ TokenPayLoadDataContextAllOfProtocolIssuer.JSON_PROPERTY_URI })
@JsonTypeName("TokenPayLoad_data_context_allOf_protocol_issuer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TokenPayLoadDataContextAllOfProtocolIssuer implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_URI = "uri";
    private URI uri;

    public TokenPayLoadDataContextAllOfProtocolIssuer() {
    }

    public TokenPayLoadDataContextAllOfProtocolIssuer uri(URI uri) {

        this.uri = uri;
        return this;
    }

    /**
     * The authorization server&#39;s issuer identifier
     *
     * @return uri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The authorization server's issuer identifier")
    @JsonProperty(JSON_PROPERTY_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public URI getUri() {
        return uri;
    }

    @JsonProperty(JSON_PROPERTY_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataContextAllOfProtocolIssuer tokenPayLoadDataContextAllOfProtocolIssuer = (TokenPayLoadDataContextAllOfProtocolIssuer) o;
        return Objects.equals(this.uri, tokenPayLoadDataContextAllOfProtocolIssuer.uri);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uri);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataContextAllOfProtocolIssuer {\n");
        sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
