package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserActivationToken
 */
@JsonPropertyOrder({ UserActivationToken.JSON_PROPERTY_ACTIVATION_TOKEN,
        UserActivationToken.JSON_PROPERTY_ACTIVATION_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserActivationToken implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIVATION_TOKEN = "activationToken";
    private String activationToken;

    public static final String JSON_PROPERTY_ACTIVATION_URL = "activationUrl";
    private String activationUrl;

    public UserActivationToken() {
    }

    /*
     * @JsonCreator public UserActivationToken(
     *
     * @JsonProperty(JSON_PROPERTY_ACTIVATION_TOKEN) String activationToken,
     *
     * @JsonProperty(JSON_PROPERTY_ACTIVATION_URL) String activationUrl ) { this(); this.activationToken =
     * activationToken; this.activationUrl = activationUrl; }
     */

    /**
     * Token received as part of an activation user request. If a password was set before the user was activated, then
     * user must sign in with their password or the &#x60;activationToken&#x60; and not the activation link. More
     * information about using the &#x60;activationToken&#x60; to login can be found in the [Authentication
     * API](https://developer.okta.com/docs/reference/api/authn/#primary-authentication-with-activation-token).
     *
     * @return activationToken
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "XE6wE17zmphl3KqAPFxO", value = "Token received as part of an activation user request. If a password was set before the user was activated, then user must sign in with their password or the `activationToken` and not the activation link. More information about using the `activationToken` to login can be found in the [Authentication API](https://developer.okta.com/docs/reference/api/authn/#primary-authentication-with-activation-token).")
    @JsonProperty(JSON_PROPERTY_ACTIVATION_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getActivationToken() {
        return activationToken;
    }

    /**
     * If &#x60;sendEmail&#x60; is &#x60;false&#x60;, returns an activation link for the user to set up their account.
     * The activation token can be used to create a custom activation link.
     *
     * @return activationUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://{yourOktaDomain}/welcome/XE6wE17zmphl3KqAPFxO", value = "If `sendEmail` is `false`, returns an activation link for the user to set up their account. The activation token can be used to create a custom activation link.")
    @JsonProperty(JSON_PROPERTY_ACTIVATION_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getActivationUrl() {
        return activationUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserActivationToken userActivationToken = (UserActivationToken) o;
        return Objects.equals(this.activationToken, userActivationToken.activationToken)
                && Objects.equals(this.activationUrl, userActivationToken.activationUrl);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(activationToken, activationUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserActivationToken {\n");
        sb.append("    activationToken: ").append(toIndentedString(activationToken)).append("\n");
        sb.append("    activationUrl: ").append(toIndentedString(activationUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
