package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactorLinks;
import com.okta.sdk.resource.model.UserFactorProvider;
import com.okta.sdk.resource.model.UserFactorStatus;
import com.okta.sdk.resource.model.UserFactorType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactor
 */
@JsonPropertyOrder({ UserFactor.JSON_PROPERTY_CREATED, UserFactor.JSON_PROPERTY_FACTOR_TYPE,
        UserFactor.JSON_PROPERTY_ID, UserFactor.JSON_PROPERTY_LAST_UPDATED, UserFactor.JSON_PROPERTY_PROFILE,
        UserFactor.JSON_PROPERTY_PROVIDER, UserFactor.JSON_PROPERTY_STATUS, UserFactor.JSON_PROPERTY_VENDOR_NAME,
        UserFactor.JSON_PROPERTY_EMBEDDED, UserFactor.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "factorType", visible = true, defaultImpl = UserFactor.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = UserFactorCall.class, name = "call"),
        @JsonSubTypes.Type(value = UserFactorEmail.class, name = "email"),
        @JsonSubTypes.Type(value = UserFactorTokenHOTP.class, name = "hotp"),
        @JsonSubTypes.Type(value = UserFactorPush.class, name = "push"),
        @JsonSubTypes.Type(value = UserFactorSecurityQuestion.class, name = "question"),
        @JsonSubTypes.Type(value = UserFactorSMS.class, name = "sms"),
        @JsonSubTypes.Type(value = UserFactorToken.class, name = "token"),
        @JsonSubTypes.Type(value = UserFactorTokenHardware.class, name = "token:hardware"),
        @JsonSubTypes.Type(value = UserFactorTokenHOTP.class, name = "token:hotp"),
        @JsonSubTypes.Type(value = UserFactorTokenSoftwareTOTP.class, name = "token:software:totp"),
        @JsonSubTypes.Type(value = UserFactorU2F.class, name = "u2f"),
        @JsonSubTypes.Type(value = UserFactorWeb.class, name = "web"),
        @JsonSubTypes.Type(value = UserFactorWebAuthn.class, name = "webauthn"), })

public class UserFactor implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
    protected UserFactorType factorType;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Object profile;

    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private UserFactorProvider provider;

    public static final String JSON_PROPERTY_STATUS = "status";
    private UserFactorStatus status;

    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorLinks links;

    public UserFactor() {
    }

    /*
     * @JsonCreator public UserFactor(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_VENDOR_NAME) String vendorName,
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded ) { this(); this.created = created; this.id =
     * id; this.lastUpdated = lastUpdated; this.vendorName = vendorName; this.embedded = embedded; }
     */

    /**
     * Timestamp when the Factor was enrolled
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2022-08-25T00:31Z", value = "Timestamp when the Factor was enrolled")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public UserFactor factorType(UserFactorType factorType) {

        this.factorType = factorType;
        return this;
    }

    /**
     * Get factorType
     *
     * @return factorType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorType getFactorType() {
        return factorType;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorType(UserFactorType factorType) {
        this.factorType = factorType;
    }

    /**
     * ID of the Factor
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "caf8m6jbcvUH8mAep1d7", value = "ID of the Factor")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the Factor was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2022-08-25T00:31Z", value = "Timestamp when the Factor was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public UserFactor profile(Object profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Specific attributes related to the Factor
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specific attributes related to the Factor")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Object profile) {
        this.profile = profile;
    }

    public UserFactor provider(UserFactorProvider provider) {

        this.provider = provider;
        return this;
    }

    /**
     * Get provider
     *
     * @return provider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorProvider getProvider() {
        return provider;
    }

    @JsonProperty(JSON_PROPERTY_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(UserFactorProvider provider) {
        this.provider = provider;
    }

    public UserFactor status(UserFactorStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(UserFactorStatus status) {
        this.status = status;
    }

    /**
     * Name of the Factor vendor. This is usually the same as the provider except for On-Prem MFA where it depends on
     * administrator settings.
     *
     * @return vendorName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "OKTA", value = "Name of the Factor vendor. This is usually the same as the provider except for On-Prem MFA where it depends on administrator settings.")
    @JsonProperty(JSON_PROPERTY_VENDOR_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVendorName() {
        return vendorName;
    }

    /**
     * Get embedded
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }

    public UserFactor links(UserFactorLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactor userFactor = (UserFactor) o;
        return Objects.equals(this.created, userFactor.created)
                && Objects.equals(this.factorType, userFactor.factorType) && Objects.equals(this.id, userFactor.id)
                && Objects.equals(this.lastUpdated, userFactor.lastUpdated)
                && Objects.equals(this.profile, userFactor.profile)
                && Objects.equals(this.provider, userFactor.provider) && Objects.equals(this.status, userFactor.status)
                && Objects.equals(this.vendorName, userFactor.vendorName)
                && Objects.equals(this.embedded, userFactor.embedded) && Objects.equals(this.links, userFactor.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, factorType, id, lastUpdated, profile, provider, status, vendorName, embedded,
                links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactor {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    factorType: ").append(toIndentedString(factorType)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    vendorName: ").append(toIndentedString(vendorName)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
