package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorVerifyRequest
 */
@JsonPropertyOrder({ UserFactorVerifyRequest.JSON_PROPERTY_PASS_CODE, UserFactorVerifyRequest.JSON_PROPERTY_ANSWER,
        UserFactorVerifyRequest.JSON_PROPERTY_CLIENT_DATA, UserFactorVerifyRequest.JSON_PROPERTY_SIGNATURE_DATA,
        UserFactorVerifyRequest.JSON_PROPERTY_AUTHENTICATOR_DATA,
        UserFactorVerifyRequest.JSON_PROPERTY_NEXT_PASS_CODE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserFactorVerifyRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASS_CODE = "passCode";
    private String passCode;

    public static final String JSON_PROPERTY_ANSWER = "answer";
    private String answer;

    public static final String JSON_PROPERTY_CLIENT_DATA = "clientData";
    private String clientData;

    public static final String JSON_PROPERTY_SIGNATURE_DATA = "signatureData";
    private String signatureData;

    public static final String JSON_PROPERTY_AUTHENTICATOR_DATA = "authenticatorData";
    private String authenticatorData;

    public static final String JSON_PROPERTY_NEXT_PASS_CODE = "nextPassCode";
    private String nextPassCode;

    public UserFactorVerifyRequest() {
    }

    public UserFactorVerifyRequest passCode(String passCode) {

        this.passCode = passCode;
        return this;
    }

    /**
     * OTP for the current time window
     *
     * @return passCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "1234567890", value = "OTP for the current time window")
    @JsonProperty(JSON_PROPERTY_PASS_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPassCode() {
        return passCode;
    }

    @JsonProperty(JSON_PROPERTY_PASS_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassCode(String passCode) {
        this.passCode = passCode;
    }

    public UserFactorVerifyRequest answer(String answer) {

        this.answer = answer;
        return this;
    }

    /**
     * Answer to the question
     *
     * @return answer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Answer to the question")
    @JsonProperty(JSON_PROPERTY_ANSWER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAnswer() {
        return answer;
    }

    @JsonProperty(JSON_PROPERTY_ANSWER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public UserFactorVerifyRequest clientData(String clientData) {

        this.clientData = clientData;
        return this;
    }

    /**
     * Base64-encoded client data from the U2F token
     *
     * @return clientData
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "eyJ0eXAiOiJuYXZpZ2F0b3IuaWQuZmluaXNoRW5yb2xsbWVudCIsImNoYWxsZW5nZSI6IlhxR0h0RTBoUkxuVEoxYUF5U1oyIiwib3JpZ2luIjoiaHR0cHM6Ly9sb2NhbGhvc3Q6MzAwMCIsImNpZF9wdWJrZXkiOiJ1bnVzZWQifQ", value = "Base64-encoded client data from the U2F token")
    @JsonProperty(JSON_PROPERTY_CLIENT_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientData() {
        return clientData;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public UserFactorVerifyRequest signatureData(String signatureData) {

        this.signatureData = signatureData;
        return this;
    }

    /**
     * Base64-encoded signature data from the U2F token
     *
     * @return signatureData
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Base64-encoded signature data from the U2F token")
    @JsonProperty(JSON_PROPERTY_SIGNATURE_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSignatureData() {
        return signatureData;
    }

    @JsonProperty(JSON_PROPERTY_SIGNATURE_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignatureData(String signatureData) {
        this.signatureData = signatureData;
    }

    public UserFactorVerifyRequest authenticatorData(String authenticatorData) {

        this.authenticatorData = authenticatorData;
        return this;
    }

    /**
     * Base64-encoded authenticator data from the WebAuthn authenticator
     *
     * @return authenticatorData
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Base64-encoded authenticator data from the WebAuthn authenticator")
    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAuthenticatorData() {
        return authenticatorData;
    }

    @JsonProperty(JSON_PROPERTY_AUTHENTICATOR_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticatorData(String authenticatorData) {
        this.authenticatorData = authenticatorData;
    }

    public UserFactorVerifyRequest nextPassCode(String nextPassCode) {

        this.nextPassCode = nextPassCode;
        return this;
    }

    /**
     * Get nextPassCode
     *
     * @return nextPassCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NEXT_PASS_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getNextPassCode() {
        return nextPassCode;
    }

    @JsonProperty(JSON_PROPERTY_NEXT_PASS_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNextPassCode(String nextPassCode) {
        this.nextPassCode = nextPassCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorVerifyRequest userFactorVerifyRequest = (UserFactorVerifyRequest) o;
        return Objects.equals(this.passCode, userFactorVerifyRequest.passCode)
                && Objects.equals(this.answer, userFactorVerifyRequest.answer)
                && Objects.equals(this.clientData, userFactorVerifyRequest.clientData)
                && Objects.equals(this.signatureData, userFactorVerifyRequest.signatureData)
                && Objects.equals(this.authenticatorData, userFactorVerifyRequest.authenticatorData)
                && Objects.equals(this.nextPassCode, userFactorVerifyRequest.nextPassCode);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(passCode, answer, clientData, signatureData, authenticatorData, nextPassCode);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorVerifyRequest {\n");
        sb.append("    passCode: ").append(toIndentedString(passCode)).append("\n");
        sb.append("    answer: ").append(toIndentedString(answer)).append("\n");
        sb.append("    clientData: ").append(toIndentedString(clientData)).append("\n");
        sb.append("    signatureData: ").append(toIndentedString(signatureData)).append("\n");
        sb.append("    authenticatorData: ").append(toIndentedString(authenticatorData)).append("\n");
        sb.append("    nextPassCode: ").append(toIndentedString(nextPassCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
