package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details of the app from which the user is being imported
 */
@ApiModel(description = "Details of the app from which the user is being imported")
@JsonPropertyOrder({ UserImportRequestDataContextApplication.JSON_PROPERTY_NAME,
        UserImportRequestDataContextApplication.JSON_PROPERTY_ID,
        UserImportRequestDataContextApplication.JSON_PROPERTY_LABEL,
        UserImportRequestDataContextApplication.JSON_PROPERTY_STATUS })
@JsonTypeName("UserImportRequestData_context_application")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserImportRequestDataContextApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    /**
     * The status of the app
     */
    public enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),

        INACTIVE(String.valueOf("INACTIVE")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public UserImportRequestDataContextApplication() {
    }

    public UserImportRequestDataContextApplication name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The app name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The app name")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public UserImportRequestDataContextApplication id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The app ID
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The app ID")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public UserImportRequestDataContextApplication label(String label) {

        this.label = label;
        return this;
    }

    /**
     * The user-defined display name for the app
     *
     * @return label
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user-defined display name for the app")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public UserImportRequestDataContextApplication status(StatusEnum status) {

        this.status = status;
        return this;
    }

    /**
     * The status of the app
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The status of the app")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportRequestDataContextApplication userImportRequestDataContextApplication = (UserImportRequestDataContextApplication) o;
        return Objects.equals(this.name, userImportRequestDataContextApplication.name)
                && Objects.equals(this.id, userImportRequestDataContextApplication.id)
                && Objects.equals(this.label, userImportRequestDataContextApplication.label)
                && Objects.equals(this.status, userImportRequestDataContextApplication.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, id, label, status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportRequestDataContextApplication {\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
