package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserSchemaAttributePermission
 */
@JsonPropertyOrder({ UserSchemaAttributePermission.JSON_PROPERTY_ACTION,
        UserSchemaAttributePermission.JSON_PROPERTY_PRINCIPAL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserSchemaAttributePermission implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTION = "action";
    private String action;

    public static final String JSON_PROPERTY_PRINCIPAL = "principal";
    private String principal;

    public UserSchemaAttributePermission() {
    }

    public UserSchemaAttributePermission action(String action) {

        this.action = action;
        return this;
    }

    /**
     * Determines whether the principal can view or modify the property
     *
     * @return action
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Determines whether the principal can view or modify the property")
    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAction() {
        return action;
    }

    @JsonProperty(JSON_PROPERTY_ACTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAction(String action) {
        this.action = action;
    }

    public UserSchemaAttributePermission principal(String principal) {

        this.principal = principal;
        return this;
    }

    /**
     * Security principal
     *
     * @return principal
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Security principal")
    @JsonProperty(JSON_PROPERTY_PRINCIPAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPrincipal() {
        return principal;
    }

    @JsonProperty(JSON_PROPERTY_PRINCIPAL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserSchemaAttributePermission userSchemaAttributePermission = (UserSchemaAttributePermission) o;
        return Objects.equals(this.action, userSchemaAttributePermission.action)
                && Objects.equals(this.principal, userSchemaAttributePermission.principal);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(action, principal);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSchemaAttributePermission {\n");
        sb.append("    action: ").append(toIndentedString(action)).append("\n");
        sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
