package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserSchemaAttribute;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserSchemaBaseProperties
 */
@JsonPropertyOrder({ UserSchemaBaseProperties.JSON_PROPERTY_CITY, UserSchemaBaseProperties.JSON_PROPERTY_COST_CENTER,
        UserSchemaBaseProperties.JSON_PROPERTY_COUNTRY_CODE, UserSchemaBaseProperties.JSON_PROPERTY_DEPARTMENT,
        UserSchemaBaseProperties.JSON_PROPERTY_DISPLAY_NAME, UserSchemaBaseProperties.JSON_PROPERTY_DIVISION,
        UserSchemaBaseProperties.JSON_PROPERTY_EMAIL, UserSchemaBaseProperties.JSON_PROPERTY_EMPLOYEE_NUMBER,
        UserSchemaBaseProperties.JSON_PROPERTY_FIRST_NAME, UserSchemaBaseProperties.JSON_PROPERTY_HONORIFIC_PREFIX,
        UserSchemaBaseProperties.JSON_PROPERTY_HONORIFIC_SUFFIX, UserSchemaBaseProperties.JSON_PROPERTY_LAST_NAME,
        UserSchemaBaseProperties.JSON_PROPERTY_LOCALE, UserSchemaBaseProperties.JSON_PROPERTY_LOGIN,
        UserSchemaBaseProperties.JSON_PROPERTY_MANAGER, UserSchemaBaseProperties.JSON_PROPERTY_MANAGER_ID,
        UserSchemaBaseProperties.JSON_PROPERTY_MIDDLE_NAME, UserSchemaBaseProperties.JSON_PROPERTY_MOBILE_PHONE,
        UserSchemaBaseProperties.JSON_PROPERTY_NICK_NAME, UserSchemaBaseProperties.JSON_PROPERTY_ORGANIZATION,
        UserSchemaBaseProperties.JSON_PROPERTY_POSTAL_ADDRESS,
        UserSchemaBaseProperties.JSON_PROPERTY_PREFERRED_LANGUAGE, UserSchemaBaseProperties.JSON_PROPERTY_PRIMARY_PHONE,
        UserSchemaBaseProperties.JSON_PROPERTY_PROFILE_URL, UserSchemaBaseProperties.JSON_PROPERTY_SECOND_EMAIL,
        UserSchemaBaseProperties.JSON_PROPERTY_STATE, UserSchemaBaseProperties.JSON_PROPERTY_STREET_ADDRESS,
        UserSchemaBaseProperties.JSON_PROPERTY_TIMEZONE, UserSchemaBaseProperties.JSON_PROPERTY_TITLE,
        UserSchemaBaseProperties.JSON_PROPERTY_USER_TYPE, UserSchemaBaseProperties.JSON_PROPERTY_ZIP_CODE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserSchemaBaseProperties implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CITY = "city";
    private UserSchemaAttribute city;

    public static final String JSON_PROPERTY_COST_CENTER = "costCenter";
    private UserSchemaAttribute costCenter;

    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private UserSchemaAttribute countryCode;

    public static final String JSON_PROPERTY_DEPARTMENT = "department";
    private UserSchemaAttribute department;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private UserSchemaAttribute displayName;

    public static final String JSON_PROPERTY_DIVISION = "division";
    private UserSchemaAttribute division;

    public static final String JSON_PROPERTY_EMAIL = "email";
    private UserSchemaAttribute email;

    public static final String JSON_PROPERTY_EMPLOYEE_NUMBER = "employeeNumber";
    private UserSchemaAttribute employeeNumber;

    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private UserSchemaAttribute firstName;

    public static final String JSON_PROPERTY_HONORIFIC_PREFIX = "honorificPrefix";
    private UserSchemaAttribute honorificPrefix;

    public static final String JSON_PROPERTY_HONORIFIC_SUFFIX = "honorificSuffix";
    private UserSchemaAttribute honorificSuffix;

    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private UserSchemaAttribute lastName;

    public static final String JSON_PROPERTY_LOCALE = "locale";
    private UserSchemaAttribute locale;

    public static final String JSON_PROPERTY_LOGIN = "login";
    private UserSchemaAttribute login;

    public static final String JSON_PROPERTY_MANAGER = "manager";
    private UserSchemaAttribute manager;

    public static final String JSON_PROPERTY_MANAGER_ID = "managerId";
    private UserSchemaAttribute managerId;

    public static final String JSON_PROPERTY_MIDDLE_NAME = "middleName";
    private UserSchemaAttribute middleName;

    public static final String JSON_PROPERTY_MOBILE_PHONE = "mobilePhone";
    private UserSchemaAttribute mobilePhone;

    public static final String JSON_PROPERTY_NICK_NAME = "nickName";
    private UserSchemaAttribute nickName;

    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    private UserSchemaAttribute organization;

    public static final String JSON_PROPERTY_POSTAL_ADDRESS = "postalAddress";
    private UserSchemaAttribute postalAddress;

    public static final String JSON_PROPERTY_PREFERRED_LANGUAGE = "preferredLanguage";
    private UserSchemaAttribute preferredLanguage;

    public static final String JSON_PROPERTY_PRIMARY_PHONE = "primaryPhone";
    private UserSchemaAttribute primaryPhone;

    public static final String JSON_PROPERTY_PROFILE_URL = "profileUrl";
    private UserSchemaAttribute profileUrl;

    public static final String JSON_PROPERTY_SECOND_EMAIL = "secondEmail";
    private UserSchemaAttribute secondEmail;

    public static final String JSON_PROPERTY_STATE = "state";
    private UserSchemaAttribute state;

    public static final String JSON_PROPERTY_STREET_ADDRESS = "streetAddress";
    private UserSchemaAttribute streetAddress;

    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private UserSchemaAttribute timezone;

    public static final String JSON_PROPERTY_TITLE = "title";
    private UserSchemaAttribute title;

    public static final String JSON_PROPERTY_USER_TYPE = "userType";
    private UserSchemaAttribute userType;

    public static final String JSON_PROPERTY_ZIP_CODE = "zipCode";
    private UserSchemaAttribute zipCode;

    public UserSchemaBaseProperties() {
    }

    public UserSchemaBaseProperties city(UserSchemaAttribute city) {

        this.city = city;
        return this;
    }

    /**
     * City or locality component of the User&#39;s address (&#x60;locality&#x60;)
     *
     * @return city
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "City or locality component of the User's address (`locality`)")
    @JsonProperty(JSON_PROPERTY_CITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getCity() {
        return city;
    }

    @JsonProperty(JSON_PROPERTY_CITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCity(UserSchemaAttribute city) {
        this.city = city;
    }

    public UserSchemaBaseProperties costCenter(UserSchemaAttribute costCenter) {

        this.costCenter = costCenter;
        return this;
    }

    /**
     * Name of a cost center assigned to the User
     *
     * @return costCenter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of a cost center assigned to the User")
    @JsonProperty(JSON_PROPERTY_COST_CENTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getCostCenter() {
        return costCenter;
    }

    @JsonProperty(JSON_PROPERTY_COST_CENTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCostCenter(UserSchemaAttribute costCenter) {
        this.costCenter = costCenter;
    }

    public UserSchemaBaseProperties countryCode(UserSchemaAttribute countryCode) {

        this.countryCode = countryCode;
        return this;
    }

    /**
     * Country name component of the User&#39;s address (&#x60;country&#x60;.) This property uses [ISO 3166-1 alpha 2
     * \&quot;short\&quot; code format](https://tools.ietf.org/html/draft-ietf-scim-core-schema-22#ref-ISO3166).
     *
     * @return countryCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Country name component of the User's address (`country`.) This property uses [ISO 3166-1 alpha 2 \"short\" code format](https://tools.ietf.org/html/draft-ietf-scim-core-schema-22#ref-ISO3166).")
    @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getCountryCode() {
        return countryCode;
    }

    @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(UserSchemaAttribute countryCode) {
        this.countryCode = countryCode;
    }

    public UserSchemaBaseProperties department(UserSchemaAttribute department) {

        this.department = department;
        return this;
    }

    /**
     * Name of the User&#39;s department
     *
     * @return department
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the User's department")
    @JsonProperty(JSON_PROPERTY_DEPARTMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getDepartment() {
        return department;
    }

    @JsonProperty(JSON_PROPERTY_DEPARTMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDepartment(UserSchemaAttribute department) {
        this.department = department;
    }

    public UserSchemaBaseProperties displayName(UserSchemaAttribute displayName) {

        this.displayName = displayName;
        return this;
    }

    /**
     * Name of the User, suitable for display to end Users
     *
     * @return displayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the User, suitable for display to end Users")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getDisplayName() {
        return displayName;
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(UserSchemaAttribute displayName) {
        this.displayName = displayName;
    }

    public UserSchemaBaseProperties division(UserSchemaAttribute division) {

        this.division = division;
        return this;
    }

    /**
     * Name of the User&#39;s division
     *
     * @return division
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the User's division")
    @JsonProperty(JSON_PROPERTY_DIVISION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getDivision() {
        return division;
    }

    @JsonProperty(JSON_PROPERTY_DIVISION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDivision(UserSchemaAttribute division) {
        this.division = division;
    }

    public UserSchemaBaseProperties email(UserSchemaAttribute email) {

        this.email = email;
        return this;
    }

    /**
     * Primary email address of the User. This property is formatted according to [RFC 5322 Section
     * 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).
     *
     * @return email
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Primary email address of the User. This property is formatted according to [RFC 5322 Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).")
    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getEmail() {
        return email;
    }

    @JsonProperty(JSON_PROPERTY_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(UserSchemaAttribute email) {
        this.email = email;
    }

    public UserSchemaBaseProperties employeeNumber(UserSchemaAttribute employeeNumber) {

        this.employeeNumber = employeeNumber;
        return this;
    }

    /**
     * Organization or company assigned unique identifier for the User
     *
     * @return employeeNumber
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Organization or company assigned unique identifier for the User")
    @JsonProperty(JSON_PROPERTY_EMPLOYEE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getEmployeeNumber() {
        return employeeNumber;
    }

    @JsonProperty(JSON_PROPERTY_EMPLOYEE_NUMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmployeeNumber(UserSchemaAttribute employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public UserSchemaBaseProperties firstName(UserSchemaAttribute firstName) {

        this.firstName = firstName;
        return this;
    }

    /**
     * Given name of the User (&#x60;givenName&#x60;)
     *
     * @return firstName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Given name of the User (`givenName`)")
    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getFirstName() {
        return firstName;
    }

    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFirstName(UserSchemaAttribute firstName) {
        this.firstName = firstName;
    }

    public UserSchemaBaseProperties honorificPrefix(UserSchemaAttribute honorificPrefix) {

        this.honorificPrefix = honorificPrefix;
        return this;
    }

    /**
     * Honorific prefix(es) of the User or title in most Western languages
     *
     * @return honorificPrefix
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Honorific prefix(es) of the User or title in most Western languages")
    @JsonProperty(JSON_PROPERTY_HONORIFIC_PREFIX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getHonorificPrefix() {
        return honorificPrefix;
    }

    @JsonProperty(JSON_PROPERTY_HONORIFIC_PREFIX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHonorificPrefix(UserSchemaAttribute honorificPrefix) {
        this.honorificPrefix = honorificPrefix;
    }

    public UserSchemaBaseProperties honorificSuffix(UserSchemaAttribute honorificSuffix) {

        this.honorificSuffix = honorificSuffix;
        return this;
    }

    /**
     * Honorific suffix(es) of the User
     *
     * @return honorificSuffix
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Honorific suffix(es) of the User")
    @JsonProperty(JSON_PROPERTY_HONORIFIC_SUFFIX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getHonorificSuffix() {
        return honorificSuffix;
    }

    @JsonProperty(JSON_PROPERTY_HONORIFIC_SUFFIX)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHonorificSuffix(UserSchemaAttribute honorificSuffix) {
        this.honorificSuffix = honorificSuffix;
    }

    public UserSchemaBaseProperties lastName(UserSchemaAttribute lastName) {

        this.lastName = lastName;
        return this;
    }

    /**
     * Family name of the User (&#x60;familyName&#x60;)
     *
     * @return lastName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Family name of the User (`familyName`)")
    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getLastName() {
        return lastName;
    }

    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastName(UserSchemaAttribute lastName) {
        this.lastName = lastName;
    }

    public UserSchemaBaseProperties locale(UserSchemaAttribute locale) {

        this.locale = locale;
        return this;
    }

    /**
     * User&#39;s default location for purposes of localizing items such as currency, date time format, numerical
     * representations, and so on. A locale value is a concatenation of the ISO 639-1 two-letter language code, an
     * underscore, and the ISO 3166-1 two-letter country code. For example: &#x60;en_US&#x60; specifies the language
     * English and country US. This value is &#x60;en_US&#x60; by default.
     *
     * @return locale
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "User's default location for purposes of localizing items such as currency, date time format, numerical representations, and so on.  A locale value is a concatenation of the ISO 639-1 two-letter language code, an underscore, and the ISO 3166-1 two-letter country code. For example: `en_US` specifies the language English and country US. This value is `en_US` by default.")
    @JsonProperty(JSON_PROPERTY_LOCALE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getLocale() {
        return locale;
    }

    @JsonProperty(JSON_PROPERTY_LOCALE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(UserSchemaAttribute locale) {
        this.locale = locale;
    }

    public UserSchemaBaseProperties login(UserSchemaAttribute login) {

        this.login = login;
        return this;
    }

    /**
     * Unique identifier for the User (&#x60;username&#x60;) The login property is validated according to its pattern
     * attribute, which is a string. By default, the attribute is null. When the attribute is null, the username is
     * required to be formatted as an email address as defined by [RFC 6531 Section
     * 3.3](http://tools.ietf.org/html/rfc6531#section-3.3). The pattern can be set through the API to one of the
     * following forms. (The Admin Console provides access to the same forms.) * A login pattern of
     * &#x60;\&quot;.+\&quot;&#x60; indicates that there is no restriction on usernames. Any non-empty, unique value is
     * permitted, and the minimum length of five isn&#39;t enforced. In this case, usernames don&#39;t need to include
     * the &#x60;@&#x60; character. If a name does include &#x60;@&#x60;, the portion ahead of the &#x60;@&#x60; can be
     * used for logging in, provided it identifies a unique User within the org. * A login pattern of the form
     * &#x60;\&quot;[...]+\&quot;&#x60; indicates that usernames must only contain characters from the set given between
     * the brackets. The enclosing brackets and final &#x60;+&#x60; are required for this form. Character ranges can be
     * indicated using hyphens. To include the hyphen itself in the allowed set, the hyphen must appear first. Any
     * characters in the set except the hyphen, a-z, A-Z, and 0-9 must be preceded by a backslash (&#x60;\\&#x60;). For
     * example, &#x60;\&quot;[a-z13579\\.]+\&quot;&#x60; would restrict usernames to lowercase letters, odd digits, and
     * periods, while &#x60;\&quot;[-a-zA-Z0-9]+\&quot;&#x60; would allow basic alphanumeric characters and hyphens.
     *
     * @return login
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Unique identifier for the User (`username`)  The login property is validated according to its pattern attribute, which is a string. By default, the attribute is null. When the attribute is null, the username is required to be formatted as an email address as defined by [RFC 6531 Section 3.3](http://tools.ietf.org/html/rfc6531#section-3.3). The pattern can be set through the API to one of the following forms. (The Admin Console provides access to the same forms.)   * A login pattern of `\".+\"` indicates that there is no restriction on usernames. Any non-empty, unique value is permitted, and the minimum length of five isn't enforced. In this case, usernames don't need to include the `@` character. If a name does include `@`, the portion ahead of the `@` can be used for logging in, provided it identifies a unique User within the org.   * A login pattern of the form `\"[...]+\"` indicates that usernames must only contain characters from the set given between the brackets. The enclosing brackets and final `+` are required for this form. Character ranges can be indicated using hyphens. To include the hyphen itself in the allowed set, the hyphen must appear first. Any characters in the set except the hyphen, a-z, A-Z, and 0-9 must be preceded by a backslash (`\\`). For example, `\"[a-z13579\\.]+\"` would restrict usernames to lowercase letters, odd digits, and periods, while `\"[-a-zA-Z0-9]+\"` would allow basic alphanumeric characters and hyphens.")
    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getLogin() {
        return login;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogin(UserSchemaAttribute login) {
        this.login = login;
    }

    public UserSchemaBaseProperties manager(UserSchemaAttribute manager) {

        this.manager = manager;
        return this;
    }

    /**
     * The &#x60;displayName&#x60; of the User&#39;s manager
     *
     * @return manager
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `displayName` of the User's manager")
    @JsonProperty(JSON_PROPERTY_MANAGER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getManager() {
        return manager;
    }

    @JsonProperty(JSON_PROPERTY_MANAGER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setManager(UserSchemaAttribute manager) {
        this.manager = manager;
    }

    public UserSchemaBaseProperties managerId(UserSchemaAttribute managerId) {

        this.managerId = managerId;
        return this;
    }

    /**
     * The &#x60;id&#x60; of the User&#39;s manager
     *
     * @return managerId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `id` of the User's manager")
    @JsonProperty(JSON_PROPERTY_MANAGER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getManagerId() {
        return managerId;
    }

    @JsonProperty(JSON_PROPERTY_MANAGER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setManagerId(UserSchemaAttribute managerId) {
        this.managerId = managerId;
    }

    public UserSchemaBaseProperties middleName(UserSchemaAttribute middleName) {

        this.middleName = middleName;
        return this;
    }

    /**
     * Middle name(s) of the User
     *
     * @return middleName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Middle name(s) of the User")
    @JsonProperty(JSON_PROPERTY_MIDDLE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getMiddleName() {
        return middleName;
    }

    @JsonProperty(JSON_PROPERTY_MIDDLE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMiddleName(UserSchemaAttribute middleName) {
        this.middleName = middleName;
    }

    public UserSchemaBaseProperties mobilePhone(UserSchemaAttribute mobilePhone) {

        this.mobilePhone = mobilePhone;
        return this;
    }

    /**
     * Mobile phone number of the User
     *
     * @return mobilePhone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Mobile phone number of the User")
    @JsonProperty(JSON_PROPERTY_MOBILE_PHONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getMobilePhone() {
        return mobilePhone;
    }

    @JsonProperty(JSON_PROPERTY_MOBILE_PHONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMobilePhone(UserSchemaAttribute mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public UserSchemaBaseProperties nickName(UserSchemaAttribute nickName) {

        this.nickName = nickName;
        return this;
    }

    /**
     * Casual way to address the User in real life
     *
     * @return nickName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Casual way to address the User in real life")
    @JsonProperty(JSON_PROPERTY_NICK_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getNickName() {
        return nickName;
    }

    @JsonProperty(JSON_PROPERTY_NICK_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNickName(UserSchemaAttribute nickName) {
        this.nickName = nickName;
    }

    public UserSchemaBaseProperties organization(UserSchemaAttribute organization) {

        this.organization = organization;
        return this;
    }

    /**
     * Name of the User&#39;s organization
     *
     * @return organization
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the User's organization")
    @JsonProperty(JSON_PROPERTY_ORGANIZATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getOrganization() {
        return organization;
    }

    @JsonProperty(JSON_PROPERTY_ORGANIZATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOrganization(UserSchemaAttribute organization) {
        this.organization = organization;
    }

    public UserSchemaBaseProperties postalAddress(UserSchemaAttribute postalAddress) {

        this.postalAddress = postalAddress;
        return this;
    }

    /**
     * Mailing address component of the User&#39;s address
     *
     * @return postalAddress
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Mailing address component of the User's address")
    @JsonProperty(JSON_PROPERTY_POSTAL_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getPostalAddress() {
        return postalAddress;
    }

    @JsonProperty(JSON_PROPERTY_POSTAL_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPostalAddress(UserSchemaAttribute postalAddress) {
        this.postalAddress = postalAddress;
    }

    public UserSchemaBaseProperties preferredLanguage(UserSchemaAttribute preferredLanguage) {

        this.preferredLanguage = preferredLanguage;
        return this;
    }

    /**
     * User&#39;s preferred written or spoken languages. This property is formatted according to [RFC 7231 Section
     * 5.3.5](https://tools.ietf.org/html/rfc7231#section-5.3.5).
     *
     * @return preferredLanguage
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "User's preferred written or spoken languages. This property is formatted according to [RFC 7231 Section 5.3.5](https://tools.ietf.org/html/rfc7231#section-5.3.5).")
    @JsonProperty(JSON_PROPERTY_PREFERRED_LANGUAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getPreferredLanguage() {
        return preferredLanguage;
    }

    @JsonProperty(JSON_PROPERTY_PREFERRED_LANGUAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPreferredLanguage(UserSchemaAttribute preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public UserSchemaBaseProperties primaryPhone(UserSchemaAttribute primaryPhone) {

        this.primaryPhone = primaryPhone;
        return this;
    }

    /**
     * Primary phone number of the User, such as home number
     *
     * @return primaryPhone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Primary phone number of the User, such as home number")
    @JsonProperty(JSON_PROPERTY_PRIMARY_PHONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getPrimaryPhone() {
        return primaryPhone;
    }

    @JsonProperty(JSON_PROPERTY_PRIMARY_PHONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPrimaryPhone(UserSchemaAttribute primaryPhone) {
        this.primaryPhone = primaryPhone;
    }

    public UserSchemaBaseProperties profileUrl(UserSchemaAttribute profileUrl) {

        this.profileUrl = profileUrl;
        return this;
    }

    /**
     * URL of the User&#39;s online Profile (for example, a web page.) This property is formatted according to the
     * [Relative Uniform Resource Locators
     * specification](https://tools.ietf.org/html/draft-ietf-scim-core-schema-22#ref-ISO3166).
     *
     * @return profileUrl
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL of the User's online Profile (for example, a web page.) This property is formatted according to the [Relative Uniform Resource Locators specification](https://tools.ietf.org/html/draft-ietf-scim-core-schema-22#ref-ISO3166).")
    @JsonProperty(JSON_PROPERTY_PROFILE_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getProfileUrl() {
        return profileUrl;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfileUrl(UserSchemaAttribute profileUrl) {
        this.profileUrl = profileUrl;
    }

    public UserSchemaBaseProperties secondEmail(UserSchemaAttribute secondEmail) {

        this.secondEmail = secondEmail;
        return this;
    }

    /**
     * Secondary email address of the User typically used for account recovery. This property is formatted according to
     * [RFC 5322 Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).
     *
     * @return secondEmail
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Secondary email address of the User typically used for account recovery. This property is formatted according to [RFC 5322 Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).")
    @JsonProperty(JSON_PROPERTY_SECOND_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getSecondEmail() {
        return secondEmail;
    }

    @JsonProperty(JSON_PROPERTY_SECOND_EMAIL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSecondEmail(UserSchemaAttribute secondEmail) {
        this.secondEmail = secondEmail;
    }

    public UserSchemaBaseProperties state(UserSchemaAttribute state) {

        this.state = state;
        return this;
    }

    /**
     * State or region component of the User&#39;s address (&#x60;region&#x60;)
     *
     * @return state
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "State or region component of the User's address (`region`)")
    @JsonProperty(JSON_PROPERTY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getState() {
        return state;
    }

    @JsonProperty(JSON_PROPERTY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setState(UserSchemaAttribute state) {
        this.state = state;
    }

    public UserSchemaBaseProperties streetAddress(UserSchemaAttribute streetAddress) {

        this.streetAddress = streetAddress;
        return this;
    }

    /**
     * Full street address component of the User&#39;s address
     *
     * @return streetAddress
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Full street address component of the User's address")
    @JsonProperty(JSON_PROPERTY_STREET_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getStreetAddress() {
        return streetAddress;
    }

    @JsonProperty(JSON_PROPERTY_STREET_ADDRESS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStreetAddress(UserSchemaAttribute streetAddress) {
        this.streetAddress = streetAddress;
    }

    public UserSchemaBaseProperties timezone(UserSchemaAttribute timezone) {

        this.timezone = timezone;
        return this;
    }

    /**
     * User&#39;s time zone. This property is formatted according to the [IANA Time Zone database
     * format](https://tools.ietf.org/html/rfc6557).
     *
     * @return timezone
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "User's time zone. This property is formatted according to the [IANA Time Zone database format](https://tools.ietf.org/html/rfc6557).")
    @JsonProperty(JSON_PROPERTY_TIMEZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getTimezone() {
        return timezone;
    }

    @JsonProperty(JSON_PROPERTY_TIMEZONE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTimezone(UserSchemaAttribute timezone) {
        this.timezone = timezone;
    }

    public UserSchemaBaseProperties title(UserSchemaAttribute title) {

        this.title = title;
        return this;
    }

    /**
     * User&#39;s title, such as \&quot;Vice President\&quot;
     *
     * @return title
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "User's title, such as \"Vice President\"")
    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getTitle() {
        return title;
    }

    @JsonProperty(JSON_PROPERTY_TITLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTitle(UserSchemaAttribute title) {
        this.title = title;
    }

    public UserSchemaBaseProperties userType(UserSchemaAttribute userType) {

        this.userType = userType;
        return this;
    }

    /**
     * Used to describe the organization to the User relationship such as \&quot;Employee\&quot; or
     * \&quot;Contractor\&quot;. **Note:** The &#x60;userType&#x60; field is an arbitrary string value and isn&#39;t
     * related to the newer [User
     * Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature.
     *
     * @return userType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Used to describe the organization to the User relationship such as \"Employee\" or \"Contractor\".  **Note:** The `userType` field is an arbitrary string value and isn't related to the newer [User Types](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/UserType/) feature.")
    @JsonProperty(JSON_PROPERTY_USER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getUserType() {
        return userType;
    }

    @JsonProperty(JSON_PROPERTY_USER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserType(UserSchemaAttribute userType) {
        this.userType = userType;
    }

    public UserSchemaBaseProperties zipCode(UserSchemaAttribute zipCode) {

        this.zipCode = zipCode;
        return this;
    }

    /**
     * ZIP code or postal code component of the User&#39;s address (&#x60;postalCode&#x60;)
     *
     * @return zipCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ZIP code or postal code component of the User's address (`postalCode`)")
    @JsonProperty(JSON_PROPERTY_ZIP_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaAttribute getZipCode() {
        return zipCode;
    }

    @JsonProperty(JSON_PROPERTY_ZIP_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setZipCode(UserSchemaAttribute zipCode) {
        this.zipCode = zipCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserSchemaBaseProperties userSchemaBaseProperties = (UserSchemaBaseProperties) o;
        return Objects.equals(this.city, userSchemaBaseProperties.city)
                && Objects.equals(this.costCenter, userSchemaBaseProperties.costCenter)
                && Objects.equals(this.countryCode, userSchemaBaseProperties.countryCode)
                && Objects.equals(this.department, userSchemaBaseProperties.department)
                && Objects.equals(this.displayName, userSchemaBaseProperties.displayName)
                && Objects.equals(this.division, userSchemaBaseProperties.division)
                && Objects.equals(this.email, userSchemaBaseProperties.email)
                && Objects.equals(this.employeeNumber, userSchemaBaseProperties.employeeNumber)
                && Objects.equals(this.firstName, userSchemaBaseProperties.firstName)
                && Objects.equals(this.honorificPrefix, userSchemaBaseProperties.honorificPrefix)
                && Objects.equals(this.honorificSuffix, userSchemaBaseProperties.honorificSuffix)
                && Objects.equals(this.lastName, userSchemaBaseProperties.lastName)
                && Objects.equals(this.locale, userSchemaBaseProperties.locale)
                && Objects.equals(this.login, userSchemaBaseProperties.login)
                && Objects.equals(this.manager, userSchemaBaseProperties.manager)
                && Objects.equals(this.managerId, userSchemaBaseProperties.managerId)
                && Objects.equals(this.middleName, userSchemaBaseProperties.middleName)
                && Objects.equals(this.mobilePhone, userSchemaBaseProperties.mobilePhone)
                && Objects.equals(this.nickName, userSchemaBaseProperties.nickName)
                && Objects.equals(this.organization, userSchemaBaseProperties.organization)
                && Objects.equals(this.postalAddress, userSchemaBaseProperties.postalAddress)
                && Objects.equals(this.preferredLanguage, userSchemaBaseProperties.preferredLanguage)
                && Objects.equals(this.primaryPhone, userSchemaBaseProperties.primaryPhone)
                && Objects.equals(this.profileUrl, userSchemaBaseProperties.profileUrl)
                && Objects.equals(this.secondEmail, userSchemaBaseProperties.secondEmail)
                && Objects.equals(this.state, userSchemaBaseProperties.state)
                && Objects.equals(this.streetAddress, userSchemaBaseProperties.streetAddress)
                && Objects.equals(this.timezone, userSchemaBaseProperties.timezone)
                && Objects.equals(this.title, userSchemaBaseProperties.title)
                && Objects.equals(this.userType, userSchemaBaseProperties.userType)
                && Objects.equals(this.zipCode, userSchemaBaseProperties.zipCode);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(city, costCenter, countryCode, department, displayName, division, email, employeeNumber,
                firstName, honorificPrefix, honorificSuffix, lastName, locale, login, manager, managerId, middleName,
                mobilePhone, nickName, organization, postalAddress, preferredLanguage, primaryPhone, profileUrl,
                secondEmail, state, streetAddress, timezone, title, userType, zipCode);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSchemaBaseProperties {\n");
        sb.append("    city: ").append(toIndentedString(city)).append("\n");
        sb.append("    costCenter: ").append(toIndentedString(costCenter)).append("\n");
        sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
        sb.append("    department: ").append(toIndentedString(department)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    division: ").append(toIndentedString(division)).append("\n");
        sb.append("    email: ").append(toIndentedString(email)).append("\n");
        sb.append("    employeeNumber: ").append(toIndentedString(employeeNumber)).append("\n");
        sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
        sb.append("    honorificPrefix: ").append(toIndentedString(honorificPrefix)).append("\n");
        sb.append("    honorificSuffix: ").append(toIndentedString(honorificSuffix)).append("\n");
        sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
        sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("    manager: ").append(toIndentedString(manager)).append("\n");
        sb.append("    managerId: ").append(toIndentedString(managerId)).append("\n");
        sb.append("    middleName: ").append(toIndentedString(middleName)).append("\n");
        sb.append("    mobilePhone: ").append(toIndentedString(mobilePhone)).append("\n");
        sb.append("    nickName: ").append(toIndentedString(nickName)).append("\n");
        sb.append("    organization: ").append(toIndentedString(organization)).append("\n");
        sb.append("    postalAddress: ").append(toIndentedString(postalAddress)).append("\n");
        sb.append("    preferredLanguage: ").append(toIndentedString(preferredLanguage)).append("\n");
        sb.append("    primaryPhone: ").append(toIndentedString(primaryPhone)).append("\n");
        sb.append("    profileUrl: ").append(toIndentedString(profileUrl)).append("\n");
        sb.append("    secondEmail: ").append(toIndentedString(secondEmail)).append("\n");
        sb.append("    state: ").append(toIndentedString(state)).append("\n");
        sb.append("    streetAddress: ").append(toIndentedString(streetAddress)).append("\n");
        sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
        sb.append("    title: ").append(toIndentedString(title)).append("\n");
        sb.append("    userType: ").append(toIndentedString(userType)).append("\n");
        sb.append("    zipCode: ").append(toIndentedString(zipCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
