package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PolicyRuleVerificationMethodType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Describes the method for verifying the user. The supported method types are &#x60;ASSURANCE&#x60; and
 * &#x60;AUTH_METHOD_CHAIN&#x60;. &lt;x-lifecycle class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt; The method type
 * &#x60;AUTH_METHOD_CHAIN&#x60; is an [Early
 * Access](https://developer.okta.com/docs/api/openapi/okta-management/guides/release-lifecycle/#early-access-ea)
 * (Self-Service) feature. You can enable the feature for your org from the **Settings** &gt; **Features** page in the
 * Admin Console.
 */
@ApiModel(description = "Describes the method for verifying the user. The supported method types are `ASSURANCE` and `AUTH_METHOD_CHAIN`.   <x-lifecycle class=\"ea\"></x-lifecycle> The method type `AUTH_METHOD_CHAIN` is an [Early Access](https://developer.okta.com/docs/api/openapi/okta-management/guides/release-lifecycle/#early-access-ea) (Self-Service) feature. You can  enable the feature for your org from the **Settings** > **Features** page in the Admin Console.")
@JsonPropertyOrder({ VerificationMethod.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-07-28T10:14:57.946459+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = VerificationMethod.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = AssuranceMethod.class, name = "ASSURANCE"),
        @JsonSubTypes.Type(value = AuthenticationMethodChainMethod.class, name = "AUTH_METHOD_CHAIN"), })

public class VerificationMethod implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TYPE = "type";
    protected PolicyRuleVerificationMethodType type;

    public VerificationMethod() {
    }

    public VerificationMethod type(PolicyRuleVerificationMethodType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyRuleVerificationMethodType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(PolicyRuleVerificationMethodType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        VerificationMethod verificationMethod = (VerificationMethod) o;
        return Objects.equals(this.type, verificationMethod.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationMethod {\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
