/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AssignGroupOwnerRequestBody;
import com.okta.sdk.resource.model.GroupOwner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class GroupOwnerApi {
    private ApiClient apiClient;

    public GroupOwnerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupOwnerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public GroupOwner assignGroupOwner(String groupId, AssignGroupOwnerRequestBody assignGroupOwnerRequestBody) throws ApiException {
        return this.assignGroupOwner(groupId, assignGroupOwnerRequestBody, Collections.emptyMap());
    }

    public GroupOwner assignGroupOwner(String groupId, AssignGroupOwnerRequestBody assignGroupOwnerRequestBody, Map<String, String> additionalHeaders) throws ApiException {
        AssignGroupOwnerRequestBody localVarPostBody = assignGroupOwnerRequestBody;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignGroupOwner");
        }
        if (assignGroupOwnerRequestBody == null) {
            throw new ApiException(400, "Missing the required parameter 'assignGroupOwnerRequestBody' when calling assignGroupOwner");
        }
        String localVarPath = "/api/v1/groups/{groupId}/owners".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<GroupOwner> localVarReturnType = new TypeReference<GroupOwner>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteGroupOwner(String groupId, String ownerId) throws ApiException {
        this.deleteGroupOwner(groupId, ownerId, Collections.emptyMap());
    }

    public void deleteGroupOwner(String groupId, String ownerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling deleteGroupOwner");
        }
        if (ownerId == null) {
            throw new ApiException(400, "Missing the required parameter 'ownerId' when calling deleteGroupOwner");
        }
        String localVarPath = "/api/v1/groups/{groupId}/owners/{ownerId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{ownerId\\}", this.apiClient.escapeString(ownerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<GroupOwner> listGroupOwners(String groupId, String search, String after, Integer limit) throws ApiException {
        return this.listGroupOwners(groupId, search, after, limit, Collections.emptyMap());
    }

    public List<GroupOwner> listGroupOwners(String groupId, String search, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listGroupOwners");
        }
        String localVarPath = "/api/v1/groups/{groupId}/owners".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<GroupOwner>> localVarReturnType = new TypeReference<List<GroupOwner>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

