/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CreateUpdateIamRolePermissionRequest;
import com.okta.sdk.resource.model.Permission;
import com.okta.sdk.resource.model.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleECustomPermissionApi {
    private ApiClient apiClient;

    public RoleECustomPermissionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleECustomPermissionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void createRolePermission(String roleIdOrLabel, String permissionType, CreateUpdateIamRolePermissionRequest instance) throws ApiException {
        this.createRolePermission(roleIdOrLabel, permissionType, instance, Collections.emptyMap());
    }

    public void createRolePermission(String roleIdOrLabel, String permissionType, CreateUpdateIamRolePermissionRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        CreateUpdateIamRolePermissionRequest localVarPostBody = instance;
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling createRolePermission");
        }
        if (permissionType == null) {
            throw new ApiException(400, "Missing the required parameter 'permissionType' when calling createRolePermission");
        }
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType}".replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString())).replaceAll("\\{permissionType\\}", this.apiClient.escapeString(permissionType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteRolePermission(String roleIdOrLabel, String permissionType) throws ApiException {
        this.deleteRolePermission(roleIdOrLabel, permissionType, Collections.emptyMap());
    }

    public void deleteRolePermission(String roleIdOrLabel, String permissionType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling deleteRolePermission");
        }
        if (permissionType == null) {
            throw new ApiException(400, "Missing the required parameter 'permissionType' when calling deleteRolePermission");
        }
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType}".replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString())).replaceAll("\\{permissionType\\}", this.apiClient.escapeString(permissionType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Permission getRolePermission(String roleIdOrLabel, String permissionType) throws ApiException {
        return this.getRolePermission(roleIdOrLabel, permissionType, Collections.emptyMap());
    }

    public Permission getRolePermission(String roleIdOrLabel, String permissionType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling getRolePermission");
        }
        if (permissionType == null) {
            throw new ApiException(400, "Missing the required parameter 'permissionType' when calling getRolePermission");
        }
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType}".replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString())).replaceAll("\\{permissionType\\}", this.apiClient.escapeString(permissionType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Permission> localVarReturnType = new TypeReference<Permission>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Permissions listRolePermissions(String roleIdOrLabel) throws ApiException {
        return this.listRolePermissions(roleIdOrLabel, Collections.emptyMap());
    }

    public Permissions listRolePermissions(String roleIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling listRolePermissions");
        }
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions".replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Permissions> localVarReturnType = new TypeReference<Permissions>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Permission replaceRolePermission(String roleIdOrLabel, String permissionType, CreateUpdateIamRolePermissionRequest instance) throws ApiException {
        return this.replaceRolePermission(roleIdOrLabel, permissionType, instance, Collections.emptyMap());
    }

    public Permission replaceRolePermission(String roleIdOrLabel, String permissionType, CreateUpdateIamRolePermissionRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        CreateUpdateIamRolePermissionRequest localVarPostBody = instance;
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling replaceRolePermission");
        }
        if (permissionType == null) {
            throw new ApiException(400, "Missing the required parameter 'permissionType' when calling replaceRolePermission");
        }
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}/permissions/{permissionType}".replaceAll("\\{roleIdOrLabel\\}", this.apiClient.escapeString(roleIdOrLabel.toString())).replaceAll("\\{permissionType\\}", this.apiClient.escapeString(permissionType.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Permission> localVarReturnType = new TypeReference<Permission>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

