/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Network Condition of the API Token")
@JsonPropertyOrder(value={"connection", "include", "exclude"})
@JsonTypeName(value="ApiToken_network")
public class ApiTokenNetwork
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CONNECTION = "connection";
    private String connection;
    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = null;
    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<String> exclude = null;

    public ApiTokenNetwork connection(String connection) {
        this.connection = connection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The connection type of the Network Condition")
    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getConnection() {
        return this.connection;
    }

    @JsonProperty(value="connection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConnection(String connection) {
        this.connection = connection;
    }

    public ApiTokenNetwork include(List<String> include) {
        this.include = include;
        return this;
    }

    public ApiTokenNetwork addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<String>();
        }
        this.include.add(includeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of included IP network zones")
    @JsonProperty(value="include")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInclude() {
        return this.include;
    }

    @JsonProperty(value="include")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    public ApiTokenNetwork exclude(List<String> exclude) {
        this.exclude = exclude;
        return this;
    }

    public ApiTokenNetwork addexcludeItem(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<String>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of excluded IP network zones")
    @JsonProperty(value="exclude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getExclude() {
        return this.exclude;
    }

    @JsonProperty(value="exclude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTokenNetwork apiTokenNetwork = (ApiTokenNetwork)o;
        return Objects.equals(this.connection, apiTokenNetwork.connection) && Objects.equals(this.include, apiTokenNetwork.include) && Objects.equals(this.exclude, apiTokenNetwork.exclude);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.include, this.exclude);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTokenNetwork {\n");
        sb.append("    connection: ").append(this.toIndentedString(this.connection)).append("\n");
        sb.append("    include: ").append(this.toIndentedString(this.include)).append("\n");
        sb.append("    exclude: ").append(this.toIndentedString(this.exclude)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

