/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonAdmin;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonUser;
import com.okta.sdk.resource.model.SecurityEventSubject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The subject's device compliance was revoked")
@JsonPropertyOrder(value={"current_status", "event_timestamp", "initiating_entity", "previous_status", "reason_admin", "reason_user", "subject"})
public class CaepDeviceComplianceChangeEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CURRENT_STATUS = "current_status";
    private CurrentStatusEnum currentStatus;
    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;
    public static final String JSON_PROPERTY_INITIATING_ENTITY = "initiating_entity";
    private InitiatingEntityEnum initiatingEntity;
    public static final String JSON_PROPERTY_PREVIOUS_STATUS = "previous_status";
    private PreviousStatusEnum previousStatus;
    public static final String JSON_PROPERTY_REASON_ADMIN = "reason_admin";
    private CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin;
    public static final String JSON_PROPERTY_REASON_USER = "reason_user";
    private CaepDeviceComplianceChangeEventReasonUser reasonUser;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SecurityEventSubject subject;

    public CaepDeviceComplianceChangeEvent currentStatus(CurrentStatusEnum currentStatus) {
        this.currentStatus = currentStatus;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="non-compliant", required=true, value="Current device compliance status")
    @JsonProperty(value="current_status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CurrentStatusEnum getCurrentStatus() {
        return this.currentStatus;
    }

    @JsonProperty(value="current_status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrentStatus(CurrentStatusEnum currentStatus) {
        this.currentStatus = currentStatus;
    }

    public CaepDeviceComplianceChangeEvent eventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1702448550", required=true, value="The time of the event (UNIX timestamp)")
    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getEventTimestamp() {
        return this.eventTimestamp;
    }

    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public CaepDeviceComplianceChangeEvent initiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The entity that initiated the event")
    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InitiatingEntityEnum getInitiatingEntity() {
        return this.initiatingEntity;
    }

    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
    }

    public CaepDeviceComplianceChangeEvent previousStatus(PreviousStatusEnum previousStatus) {
        this.previousStatus = previousStatus;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Previous device compliance status")
    @JsonProperty(value="previous_status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PreviousStatusEnum getPreviousStatus() {
        return this.previousStatus;
    }

    @JsonProperty(value="previous_status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPreviousStatus(PreviousStatusEnum previousStatus) {
        this.previousStatus = previousStatus;
    }

    public CaepDeviceComplianceChangeEvent reasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepDeviceComplianceChangeEventReasonAdmin getReasonAdmin() {
        return this.reasonAdmin;
    }

    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
    }

    public CaepDeviceComplianceChangeEvent reasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepDeviceComplianceChangeEventReasonUser getReasonUser() {
        return this.reasonUser;
    }

    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
    }

    public CaepDeviceComplianceChangeEvent subject(SecurityEventSubject subject) {
        this.subject = subject;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityEventSubject getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubject(SecurityEventSubject subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaepDeviceComplianceChangeEvent caepDeviceComplianceChangeEvent = (CaepDeviceComplianceChangeEvent)o;
        return Objects.equals((Object)this.currentStatus, (Object)caepDeviceComplianceChangeEvent.currentStatus) && Objects.equals(this.eventTimestamp, caepDeviceComplianceChangeEvent.eventTimestamp) && Objects.equals((Object)this.initiatingEntity, (Object)caepDeviceComplianceChangeEvent.initiatingEntity) && Objects.equals((Object)this.previousStatus, (Object)caepDeviceComplianceChangeEvent.previousStatus) && Objects.equals(this.reasonAdmin, caepDeviceComplianceChangeEvent.reasonAdmin) && Objects.equals(this.reasonUser, caepDeviceComplianceChangeEvent.reasonUser) && Objects.equals(this.subject, caepDeviceComplianceChangeEvent.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currentStatus, this.eventTimestamp, this.initiatingEntity, this.previousStatus, this.reasonAdmin, this.reasonUser, this.subject});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaepDeviceComplianceChangeEvent {\n");
        sb.append("    currentStatus: ").append(this.toIndentedString((Object)this.currentStatus)).append("\n");
        sb.append("    eventTimestamp: ").append(this.toIndentedString(this.eventTimestamp)).append("\n");
        sb.append("    initiatingEntity: ").append(this.toIndentedString((Object)this.initiatingEntity)).append("\n");
        sb.append("    previousStatus: ").append(this.toIndentedString((Object)this.previousStatus)).append("\n");
        sb.append("    reasonAdmin: ").append(this.toIndentedString(this.reasonAdmin)).append("\n");
        sb.append("    reasonUser: ").append(this.toIndentedString(this.reasonUser)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CurrentStatusEnum {
        COMPLIANT(String.valueOf("compliant")),
        NOT_COMPLIANT(String.valueOf("not-compliant")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private CurrentStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrentStatusEnum fromValue(String value) {
            for (CurrentStatusEnum b : CurrentStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum InitiatingEntityEnum {
        ADMIN(String.valueOf("admin")),
        USER(String.valueOf("user")),
        POLICY(String.valueOf("policy")),
        SYSTEM(String.valueOf("system")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private InitiatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InitiatingEntityEnum fromValue(String value) {
            for (InitiatingEntityEnum b : InitiatingEntityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum PreviousStatusEnum {
        COMPLIANT(String.valueOf("compliant")),
        NOT_COMPLIANT(String.valueOf("not-compliant")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private PreviousStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PreviousStatusEnum fromValue(String value) {
            for (PreviousStatusEnum b : PreviousStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

