/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ECKeyJWK;
import com.okta.sdk.resource.model.WebAuthnCredResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Enrollment Initialization Request")
@JsonPropertyOrder(value={"credResponses", "fulfillmentProvider", "pinResponseJwe", "serial", "userId", "version", "yubicoSigningJwks"})
public class EnrollmentActivationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CRED_RESPONSES = "credResponses";
    private List<WebAuthnCredResponse> credResponses = null;
    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;
    public static final String JSON_PROPERTY_PIN_RESPONSE_JWE = "pinResponseJwe";
    private String pinResponseJwe;
    public static final String JSON_PROPERTY_SERIAL = "serial";
    private String serial;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    public static final String JSON_PROPERTY_YUBICO_SIGNING_JWKS = "yubicoSigningJwks";
    private List<ECKeyJWK> yubicoSigningJwks = null;

    public EnrollmentActivationRequest credResponses(List<WebAuthnCredResponse> credResponses) {
        this.credResponses = credResponses;
        return this;
    }

    public EnrollmentActivationRequest addcredResponsesItem(WebAuthnCredResponse credResponsesItem) {
        if (this.credResponses == null) {
            this.credResponses = new ArrayList<WebAuthnCredResponse>();
        }
        this.credResponses.add(credResponsesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of credential responses from the fulfillment provider")
    @JsonProperty(value="credResponses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WebAuthnCredResponse> getCredResponses() {
        return this.credResponses;
    }

    @JsonProperty(value="credResponses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredResponses(List<WebAuthnCredResponse> credResponses) {
        this.credResponses = credResponses;
    }

    public EnrollmentActivationRequest fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FulfillmentProviderEnum getFulfillmentProvider() {
        return this.fulfillmentProvider;
    }

    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public EnrollmentActivationRequest pinResponseJwe(String pinResponseJwe) {
        this.pinResponseJwe = pinResponseJwe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Encrypted JWE of PIN response from the fulfillment provider")
    @JsonProperty(value="pinResponseJwe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPinResponseJwe() {
        return this.pinResponseJwe;
    }

    @JsonProperty(value="pinResponseJwe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPinResponseJwe(String pinResponseJwe) {
        this.pinResponseJwe = pinResponseJwe;
    }

    public EnrollmentActivationRequest serial(String serial) {
        this.serial = serial;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Serial number of the YubiKey")
    @JsonProperty(value="serial")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSerial() {
        return this.serial;
    }

    @JsonProperty(value="serial")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSerial(String serial) {
        this.serial = serial;
    }

    public EnrollmentActivationRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of an existing Okta user")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public EnrollmentActivationRequest version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Firmware version of the YubiKey")
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(String version) {
        this.version = version;
    }

    public EnrollmentActivationRequest yubicoSigningJwks(List<ECKeyJWK> yubicoSigningJwks) {
        this.yubicoSigningJwks = yubicoSigningJwks;
        return this;
    }

    public EnrollmentActivationRequest addyubicoSigningJwksItem(ECKeyJWK yubicoSigningJwksItem) {
        if (this.yubicoSigningJwks == null) {
            this.yubicoSigningJwks = new ArrayList<ECKeyJWK>();
        }
        this.yubicoSigningJwks.add(yubicoSigningJwksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of usable signing keys from Yubico (in JWKS format) used to verify the JWS inside the JWE")
    @JsonProperty(value="yubicoSigningJwks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ECKeyJWK> getYubicoSigningJwks() {
        return this.yubicoSigningJwks;
    }

    @JsonProperty(value="yubicoSigningJwks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setYubicoSigningJwks(List<ECKeyJWK> yubicoSigningJwks) {
        this.yubicoSigningJwks = yubicoSigningJwks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrollmentActivationRequest enrollmentActivationRequest = (EnrollmentActivationRequest)o;
        return Objects.equals(this.credResponses, enrollmentActivationRequest.credResponses) && Objects.equals((Object)this.fulfillmentProvider, (Object)enrollmentActivationRequest.fulfillmentProvider) && Objects.equals(this.pinResponseJwe, enrollmentActivationRequest.pinResponseJwe) && Objects.equals(this.serial, enrollmentActivationRequest.serial) && Objects.equals(this.userId, enrollmentActivationRequest.userId) && Objects.equals(this.version, enrollmentActivationRequest.version) && Objects.equals(this.yubicoSigningJwks, enrollmentActivationRequest.yubicoSigningJwks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credResponses, this.fulfillmentProvider, this.pinResponseJwe, this.serial, this.userId, this.version, this.yubicoSigningJwks});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrollmentActivationRequest {\n");
        sb.append("    credResponses: ").append(this.toIndentedString(this.credResponses)).append("\n");
        sb.append("    fulfillmentProvider: ").append(this.toIndentedString((Object)this.fulfillmentProvider)).append("\n");
        sb.append("    pinResponseJwe: ").append(this.toIndentedString(this.pinResponseJwe)).append("\n");
        sb.append("    serial: ").append(this.toIndentedString(this.serial)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    yubicoSigningJwks: ").append(this.toIndentedString(this.yubicoSigningJwks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FulfillmentProviderEnum {
        YUBICO(String.valueOf("yubico")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

