/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Profile for a Group that is imported from Active Directory.  The `objectClass` for such groups is `okta:windows_security_principal`.")
@JsonPropertyOrder(value={"description", "dn", "externalId", "name", "samAccountName", "windowsDomainQualifiedName"})
public class OktaActiveDirectoryGroupProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DN = "dn";
    private String dn;
    public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
    private String externalId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SAM_ACCOUNT_NAME = "samAccountName";
    private String samAccountName;
    public static final String JSON_PROPERTY_WINDOWS_DOMAIN_QUALIFIED_NAME = "windowsDomainQualifiedName";
    private String windowsDomainQualifiedName;

    public OktaActiveDirectoryGroupProfile description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="example.com/West Coast/West Coast Users", value="Description of the Windows Group")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public OktaActiveDirectoryGroupProfile dn(String dn) {
        this.dn = dn;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CN=West Coast Users,OU=West Coast,DC=example,DC=com", value="The distinguished name of the Windows Group")
    @JsonProperty(value="dn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDn() {
        return this.dn;
    }

    @JsonProperty(value="dn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDn(String dn) {
        this.dn = dn;
    }

    public OktaActiveDirectoryGroupProfile externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="VKzYZ1C+IkSZxIWlrW5ITg==", value="Base-64 encoded GUID (`objectGUID`) of the Windows Group")
    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="externalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public OktaActiveDirectoryGroupProfile name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="West Coast Users", value="Name of the Windows Group")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OktaActiveDirectoryGroupProfile samAccountName(String samAccountName) {
        this.samAccountName = samAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="West Coast Users", value="Pre-Windows 2000 name of the Windows Group")
    @JsonProperty(value="samAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSamAccountName() {
        return this.samAccountName;
    }

    @JsonProperty(value="samAccountName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSamAccountName(String samAccountName) {
        this.samAccountName = samAccountName;
    }

    public OktaActiveDirectoryGroupProfile windowsDomainQualifiedName(String windowsDomainQualifiedName) {
        this.windowsDomainQualifiedName = windowsDomainQualifiedName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="EXAMPLE\\\\West Coast Users", value="Fully qualified name of the Windows Group")
    @JsonProperty(value="windowsDomainQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWindowsDomainQualifiedName() {
        return this.windowsDomainQualifiedName;
    }

    @JsonProperty(value="windowsDomainQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWindowsDomainQualifiedName(String windowsDomainQualifiedName) {
        this.windowsDomainQualifiedName = windowsDomainQualifiedName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OktaActiveDirectoryGroupProfile oktaActiveDirectoryGroupProfile = (OktaActiveDirectoryGroupProfile)o;
        return Objects.equals(this.description, oktaActiveDirectoryGroupProfile.description) && Objects.equals(this.dn, oktaActiveDirectoryGroupProfile.dn) && Objects.equals(this.externalId, oktaActiveDirectoryGroupProfile.externalId) && Objects.equals(this.name, oktaActiveDirectoryGroupProfile.name) && Objects.equals(this.samAccountName, oktaActiveDirectoryGroupProfile.samAccountName) && Objects.equals(this.windowsDomainQualifiedName, oktaActiveDirectoryGroupProfile.windowsDomainQualifiedName);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.dn, this.externalId, this.name, this.samAccountName, this.windowsDomainQualifiedName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaActiveDirectoryGroupProfile {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dn: ").append(this.toIndentedString(this.dn)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    samAccountName: ").append(this.toIndentedString(this.samAccountName)).append("\n");
        sb.append("    windowsDomainQualifiedName: ").append(this.toIndentedString(this.windowsDomainQualifiedName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

