/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SsprPrimaryRequirement;
import com.okta.sdk.resource.model.SsprStepUpRequirement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="<x-lifecycle class=\"oie\"></x-lifecycle> Describes the initial and secondary authenticator requirements a user needs to reset their password")
@JsonPropertyOrder(value={"accessControl", "primary", "stepUp"})
public class SsprRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCESS_CONTROL = "accessControl";
    private AccessControlEnum accessControl;
    public static final String JSON_PROPERTY_PRIMARY = "primary";
    private SsprPrimaryRequirement primary;
    public static final String JSON_PROPERTY_STEP_UP = "stepUp";
    private SsprStepUpRequirement stepUp;

    public SsprRequirement accessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines which authentication requirements a user needs to perform self-service operations. `AUTH_POLICY` defers conditions and authentication requirements to the [Okta account management policy](https://developer.okta.com/docs/guides/okta-account-management-policy/main/). `LEGACY` refers to the requirements described by this rule.")
    @JsonProperty(value="accessControl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccessControlEnum getAccessControl() {
        return this.accessControl;
    }

    @JsonProperty(value="accessControl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessControl(AccessControlEnum accessControl) {
        this.accessControl = accessControl;
    }

    public SsprRequirement primary(SsprPrimaryRequirement primary) {
        this.primary = primary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SsprPrimaryRequirement getPrimary() {
        return this.primary;
    }

    @JsonProperty(value="primary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrimary(SsprPrimaryRequirement primary) {
        this.primary = primary;
    }

    public SsprRequirement stepUp(SsprStepUpRequirement stepUp) {
        this.stepUp = stepUp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="stepUp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SsprStepUpRequirement getStepUp() {
        return this.stepUp;
    }

    @JsonProperty(value="stepUp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStepUp(SsprStepUpRequirement stepUp) {
        this.stepUp = stepUp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsprRequirement ssprRequirement = (SsprRequirement)o;
        return Objects.equals((Object)this.accessControl, (Object)ssprRequirement.accessControl) && Objects.equals(this.primary, ssprRequirement.primary) && Objects.equals(this.stepUp, ssprRequirement.stepUp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessControl, this.primary, this.stepUp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SsprRequirement {\n");
        sb.append("    accessControl: ").append(this.toIndentedString((Object)this.accessControl)).append("\n");
        sb.append("    primary: ").append(this.toIndentedString(this.primary)).append("\n");
        sb.append("    stepUp: ").append(this.toIndentedString(this.stepUp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccessControlEnum {
        AUTH_POLICY(String.valueOf("AUTH_POLICY")),
        LEGACY(String.valueOf("LEGACY")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private AccessControlEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessControlEnum fromValue(String value) {
            for (AccessControlEnum b : AccessControlEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

