/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"answer", "question", "questionText"})
public class UserFactorSecurityQuestionProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ANSWER = "answer";
    private String answer;
    public static final String JSON_PROPERTY_QUESTION = "question";
    private QuestionEnum question;
    public static final String JSON_PROPERTY_QUESTION_TEXT = "questionText";
    private String questionText;

    public UserFactorSecurityQuestionProfile answer(String answer) {
        this.answer = answer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Answer to the question")
    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAnswer() {
        return this.answer;
    }

    @JsonProperty(value="answer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public UserFactorSecurityQuestionProfile question(QuestionEnum question) {
        this.question = question;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="disliked_food", value="Unique key for the question")
    @JsonProperty(value="question")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public QuestionEnum getQuestion() {
        return this.question;
    }

    @JsonProperty(value="question")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuestion(QuestionEnum question) {
        this.question = question;
    }

    @Nullable
    @ApiModelProperty(example="What is the food you least liked as a child?", value="Human-readable text that's displayed to the user")
    @JsonProperty(value="questionText")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuestionText() {
        return this.questionText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactorSecurityQuestionProfile userFactorSecurityQuestionProfile = (UserFactorSecurityQuestionProfile)o;
        return Objects.equals(this.answer, userFactorSecurityQuestionProfile.answer) && Objects.equals((Object)this.question, (Object)userFactorSecurityQuestionProfile.question) && Objects.equals(this.questionText, userFactorSecurityQuestionProfile.questionText);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.answer, this.question, this.questionText});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorSecurityQuestionProfile {\n");
        sb.append("    answer: ").append(this.toIndentedString(this.answer)).append("\n");
        sb.append("    question: ").append(this.toIndentedString((Object)this.question)).append("\n");
        sb.append("    questionText: ").append(this.toIndentedString(this.questionText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum QuestionEnum {
        DISLIKED_FOOD(String.valueOf("disliked_food")),
        NAME_OF_FIRST_PLUSH_TOY(String.valueOf("name_of_first_plush_toy")),
        FIRST_AWARD(String.valueOf("first_award")),
        FAVORITE_SECURITY_QUESTION(String.valueOf("favorite_security_question")),
        FAVORITE_TOY(String.valueOf("favorite_toy")),
        FIRST_COMPUTER_GAME(String.valueOf("first_computer_game")),
        FAVORITE_MOVIE_QUOTE(String.valueOf("favorite_movie_quote")),
        FIRST_SPORTS_TEAM_MASCOT(String.valueOf("first_sports_team_mascot")),
        FIRST_MUSIC_PURCHASE(String.valueOf("first_music_purchase")),
        FAVORITE_ART_PIECE(String.valueOf("favorite_art_piece")),
        GRANDMOTHER_FAVORITE_DESERT(String.valueOf("grandmother_favorite_desert")),
        FIRST_THING_COOKED(String.valueOf("first_thing_cooked")),
        CHILDHOOD_DREAM_JOB(String.valueOf("childhood_dream_job")),
        FIRST_KISS_LOCATION(String.valueOf("first_kiss_location")),
        PLACE_WHERE_SIGNIFICANT_OTHER_WAS_MET(String.valueOf("place_where_significant_other_was_met")),
        FAVORITE_VACATION_LOCATION(String.valueOf("favorite_vacation_location")),
        NEW_YEARS_TWO_THOUSAND(String.valueOf("new_years_two_thousand")),
        FAVORITE_SPEAKER_ACTOR(String.valueOf("favorite_speaker_actor")),
        FAVORITE_BOOK_MOVIE_CHARACTER(String.valueOf("favorite_book_movie_character")),
        FAVORITE_SPORTS_PLAYER(String.valueOf("favorite_sports_player")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private QuestionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static QuestionEnum fromValue(String value) {
            for (QuestionEnum b : QuestionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

