/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.2.1
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.identity.provider;

import com.okta.sdk.resource.application.Csr;
import com.okta.sdk.resource.application.CsrList;
import com.okta.sdk.resource.application.CsrMetadata;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.identity.provider.IdentityProvider;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUser;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUserList;
import com.okta.sdk.resource.identity.provider.Protocol;
import com.okta.sdk.resource.identity.provider.SocialAuthTokenList;
import com.okta.sdk.resource.policy.IdentityProviderPolicy;
import com.okta.sdk.resource.policy.UserIdentityProviderLinkRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * IdentityProvider
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2021-03-15T15:18:19.674-07:00")
public interface IdentityProvider extends ExtensibleResource, Deletable {

    Map<String, Object> getLinks();

    Date getCreated();

    String getId();

    IssuerModeEnum getIssuerMode();

    IdentityProvider setIssuerMode(IssuerModeEnum issuerMode);

          /**
   * Enum issuerMode
   */
  public enum IssuerModeEnum {
    ORG_URL("ORG_URL"),
    
    CUSTOM_URL_DOMAIN("CUSTOM_URL_DOMAIN");

    private String value;

    IssuerModeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

    Date getLastUpdated();

    String getName();

    IdentityProvider setName(String name);

    IdentityProviderPolicy getPolicy();

    IdentityProvider setPolicy(IdentityProviderPolicy policy);

    Protocol getProtocol();

    IdentityProvider setProtocol(Protocol protocol);

    StatusEnum getStatus();

    IdentityProvider setStatus(StatusEnum status);

          /**
   * Enum status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

    TypeEnum getType();

    IdentityProvider setType(TypeEnum type);

          /**
   * Enum type
   */
  public enum TypeEnum {
    SAML2("SAML2"),
    
    GOOGLE("GOOGLE"),
    
    FACEBOOK("FACEBOOK"),
    
    LINKEDIN("LINKEDIN"),
    
    MICROSOFT("MICROSOFT"),
    
    OIDC("OIDC"),
    
    OKTA("OKTA"),
    
    IWA("IWA"),
    
    AGENTLESSDSSO("AgentlessDSSO"),
    
    X509("X509");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }


    /**
    * 
    * Fetches a linked IdP user by ID
    * @param userId  (required)
    * @return IdentityProviderApplicationUser
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "GET - /api/v1/idps/{idpId}/users/{userId}")
    IdentityProviderApplicationUser getUser(String userId);


    /**
    * 
    * Gets a specific Certificate Signing Request model by id
    * @param csrId  (required)
    * @return Csr
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "GET - /api/v1/idps/{idpId}/credentials/csrs/{csrId}")
    Csr getSigningCsr(String csrId);


    /**
    * Delete Identity Provider
    * Removes an IdP from your organization.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "DELETE - /api/v1/idps/{idpId}")
    void delete();


    /**
    * Generate Certificate Signing Request for IdP
    * Generates a new key pair and returns a Certificate Signing Request for it.
    * @param metadata  (required)
    * @return Csr
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "POST - /api/v1/idps/{idpId}/credentials/csrs")
    Csr generateCsr(CsrMetadata metadata);


    /**
    * Activate Identity Provider
    * Activates an inactive IdP.
    * @return IdentityProvider
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "POST - /api/v1/idps/{idpId}/lifecycle/activate")
    IdentityProvider activate();


    /**
    * Link a user to a Social IdP without a transaction
    * Links an Okta user to an existing Social Identity Provider. This does not support the SAML2 Identity Provider Type
    * @param userId  (required)
    * @param userIdentityProviderLinkRequest  (required)
    * @return IdentityProviderApplicationUser
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "POST - /api/v1/idps/{idpId}/users/{userId}")
    IdentityProviderApplicationUser linkUser(String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest);


    /**
    * Social Authentication Token Operation
    * Fetches the tokens minted by the Social Authentication Provider when the user authenticates with Okta via Social Auth.
    * @param userId  (required)
    * @return SocialAuthTokenList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "GET - /api/v1/idps/{idpId}/users/{userId}/credentials/tokens")
    SocialAuthTokenList listSocialAuthTokens(String userId);


    /**
    * List Signing Key Credentials for IdP
    * Enumerates signing key credentials for an IdP
    * @return JsonWebKeyList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "GET - /api/v1/idps/{idpId}/credentials/keys")
    JsonWebKeyList listSigningKeys();


    /**
    * 
    * Revoke a Certificate Signing Request and delete the key pair from the IdP
    * @param csrId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "DELETE - /api/v1/idps/{idpId}/credentials/csrs/{csrId}")
    void deleteSigningCsr(String csrId);


    /**
    * Get Signing Key Credential for IdP
    * Gets a specific IdP Key Credential by &#x60;kid&#x60;
    * @param keyId  (required)
    * @return JsonWebKey
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "GET - /api/v1/idps/{idpId}/credentials/keys/{keyId}")
    JsonWebKey getSigningKey(String keyId);


    /**
    * Update Identity Provider
    * Updates the configuration for an IdP.
    * @param identityProvider  (required)
    * @return IdentityProvider
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "PUT - /api/v1/idps/{idpId}")
    IdentityProvider update(IdentityProvider identityProvider);


    /**
    * Generate New IdP Signing Key Credential
    * Generates a new X.509 certificate for an IdP signing key credential to be used for signing assertions sent to the IdP
    * @param validityYears expiry of the IdP Key Credential (required)
    * @return JsonWebKey
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "POST - /api/v1/idps/{idpId}/credentials/keys/generate")
    JsonWebKey generateSigningKey(Integer validityYears);


    /**
    * Find Users
    * Find all the users linked to an identity provider
    * @return IdentityProviderApplicationUserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "GET - /api/v1/idps/{idpId}/users")
    IdentityProviderApplicationUserList listUsers();


    /**
    * Unlink User from IdP
    * Removes the link between the Okta user and the IdP user.
    * @param userId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "DELETE - /api/v1/idps/{idpId}/users/{userId}")
    void unlinkUser(String userId);


    /**
    * List Certificate Signing Requests for IdP
    * Enumerates Certificate Signing Requests for an IdP
    * @return CsrList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "GET - /api/v1/idps/{idpId}/credentials/csrs")
    CsrList listSigningCsrs();


    /**
    * Deactivate Identity Provider
    * Deactivates an active IdP.
    * @return IdentityProvider
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "POST - /api/v1/idps/{idpId}/lifecycle/deactivate")
    IdentityProvider deactivate();


    /**
    * Clone Signing Key Credential for IdP
    * Clones a X.509 certificate for an IdP signing key credential from a source IdP to target IdP
    * @param keyId  (required)
    * @param targetIdpId  (required)
    * @return JsonWebKey
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2021-03-15T15:18:19.674-07:00",
            comments = "POST - /api/v1/idps/{idpId}/credentials/keys/{keyId}/clone")
    JsonWebKey cloneKey(String keyId, String targetIdpId);


}

