/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 2.12.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.okta.sdk.client;

import com.okta.sdk.resource.user.factor.ActivateFactorRequest;
import com.okta.sdk.resource.user.AppLink;
import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationFeature;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.role.AssignRoleRequest;
import com.okta.sdk.resource.authenticator.Authenticator;
import com.okta.sdk.resource.authorization.server.AuthorizationServer;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicy;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.brand.Brand;
import com.okta.sdk.resource.application.CapabilitiesObject;
import com.okta.sdk.resource.role.CatalogApplication;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.session.CreateSessionRequest;
import com.okta.sdk.resource.user.CreateUserRequest;
import com.okta.sdk.resource.application.Csr;
import com.okta.sdk.resource.application.CsrMetadata;
import java.util.Date;
import com.okta.sdk.resource.domain.Domain;
import com.okta.sdk.resource.domain.DomainCertificate;
import com.okta.sdk.resource.domain.DomainListResponse;
import com.okta.sdk.resource.brands.EmailTemplate;
import com.okta.sdk.resource.brands.EmailTemplateContent;
import com.okta.sdk.resource.brands.EmailTemplateCustomization;
import com.okta.sdk.resource.brands.EmailTemplateCustomizationRequest;
import com.okta.sdk.resource.brands.EmailTemplateTestRequest;
import com.okta.sdk.resource.event.hook.EventHook;
import com.okta.sdk.resource.feature.Feature;
import java.io.File;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.group.schema.GroupSchema;
import com.okta.sdk.resource.identity.provider.IdentityProvider;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUser;
import com.okta.sdk.resource.brand.ImageUploadResponse;
import com.okta.sdk.resource.inline.hook.InlineHook;
import com.okta.sdk.resource.inline.hook.InlineHookPayload;
import com.okta.sdk.resource.inline.hook.InlineHookResponse;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.application.JwkUse;
import com.okta.sdk.resource.linked.object.LinkedObject;
import com.okta.sdk.resource.log.LogEvent;
import com.okta.sdk.resource.network.zone.NetworkZone;
import com.okta.sdk.resource.application.OAuth2Claim;
import com.okta.sdk.resource.application.OAuth2Client;
import com.okta.sdk.resource.application.OAuth2RefreshToken;
import com.okta.sdk.resource.application.OAuth2Scope;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrant;
import com.okta.sdk.resource.application.OAuth2Token;
import com.okta.sdk.resource.org.OrgContactTypeObj;
import com.okta.sdk.resource.org.OrgContactUser;
import com.okta.sdk.resource.org.OrgOktaCommunicationSetting;
import com.okta.sdk.resource.org.OrgOktaSupportSettingsObj;
import com.okta.sdk.resource.org.OrgPreferences;
import com.okta.sdk.resource.org.OrgSetting;
import com.okta.sdk.resource.policy.Policy;
import com.okta.sdk.resource.policy.PolicyRule;
import com.okta.sdk.resource.profile.mapping.ProfileMapping;
import com.okta.sdk.resource.application.ProvisioningConnection;
import com.okta.sdk.resource.application.ProvisioningConnectionRequest;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.ResponseLinks;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.factor.SecurityQuestion;
import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.template.SmsTemplate;
import com.okta.sdk.resource.identity.provider.SocialAuthToken;
import com.okta.sdk.resource.role.Subscription;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.brand.Theme;
import com.okta.sdk.resource.brand.ThemeResponse;
import com.okta.sdk.resource.threat.insight.ThreatInsightConfiguration;
import com.okta.sdk.resource.trusted.origin.TrustedOrigin;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.org.UserIdString;
import com.okta.sdk.resource.policy.UserIdentityProviderLinkRequest;
import com.okta.sdk.resource.user.schema.UserSchema;
import com.okta.sdk.resource.user.type.UserType;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyUserFactorResponse;
import com.okta.sdk.resource.application.OAuth2ClaimList;
import com.okta.sdk.resource.linked.object.LinkedObjectList;
import com.okta.sdk.resource.org.OrgContactTypeObjList;
import com.okta.sdk.resource.brand.ThemeResponseList;
import com.okta.sdk.resource.application.CsrList;
import com.okta.sdk.resource.policy.PolicyList;
import com.okta.sdk.resource.identity.provider.IdentityProviderList;
import com.okta.sdk.resource.application.OAuth2ClientList;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.network.zone.NetworkZoneList;
import com.okta.sdk.resource.user.UserNextLogin;
import com.okta.sdk.resource.identity.provider.SocialAuthTokenList;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.inline.hook.InlineHookList;
import com.okta.sdk.resource.policy.PolicyRuleList;
import com.okta.sdk.resource.profile.mapping.ProfileMappingList;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import com.okta.sdk.resource.template.SmsTemplateType;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.feature.FeatureList;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.authorization.server.AuthorizationServerList;
import com.okta.sdk.resource.trusted.origin.TrustedOriginList;
import com.okta.sdk.resource.identity.provider.IdentityProviderApplicationUserList;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.role.CatalogApplicationList;
import com.okta.sdk.resource.application.OAuth2ScopeList;
import com.okta.sdk.resource.event.hook.EventHookList;
import com.okta.sdk.resource.user.factor.UserFactorList;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.application.ApplicationFeatureList;
import com.okta.sdk.resource.template.SmsTemplateList;
import com.okta.sdk.resource.authorization.server.policy.AuthorizationServerPolicyRuleList;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.role.SubscriptionList;
import com.okta.sdk.resource.brand.BrandList;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.application.OAuth2ScopeConsentGrantList;
import com.okta.sdk.resource.brands.EmailTemplateCustomizationList;
import com.okta.sdk.resource.brands.EmailTemplateList;
import com.okta.sdk.resource.application.OAuth2RefreshTokenList;
import com.okta.sdk.resource.user.type.UserTypeList;
import com.okta.sdk.resource.authorization.server.AuthorizationServerPolicyList;
import com.okta.sdk.resource.authenticator.AuthenticatorList;
import com.okta.sdk.resource.user.ResponseLinksList;
import com.okta.sdk.resource.application.OAuth2TokenList;
import com.okta.sdk.resource.user.RoleList;

import java.util.LinkedHashMap;
import com.okta.sdk.ds.DataStore;

/**
* The {@code Client} is the main entry point to the Okta Java SDK.  A JVM project wishing to
* communicate with the Okta REST API service must build a {@code Client} instance.  After obtaining
* a {@code Client instance}, the REST API may be used by making simple Java calls on objects returned from
* the Client (or any children objects obtained therein).
* <p>
* For example:
* <pre>
* Client client = Clients.builder().build();
*
* client.getUser(userId)
* </pre>
* @see <a href="https://developer.okta.com/docs/guides/create-an-api-token/overview">Communicating with Okta: Get your API Token</a>
* @see DataStore
* @since 0.5.0
*/
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
                            date  = "2022-04-28T13:49:19.036-05:00")
public interface Client extends DataStore {

    /**
    * Returns the internal {@link DataStore} of the client.  It is typically not necessary to invoke this method as
    * the Client implements the {@link DataStore} API and will delegate to this instance automatically.
    *
    * @return the client's internal {@link DataStore}.
    */
    DataStore getDataStore();

    /**
    * List Applications
    * Enumerates apps added to your organization with pagination. A subset of apps can be returned that match a supported filter expression or query.
    * @param q  (optional)
    * @param filter Filters apps by status, user.id, group.id or credentials.signing.kid expression (optional)
    * @param expand Traverses users link relationship and optionally embeds Application User resource (optional)
    * @param includeNonDeleted  (optional, default to false)
    * @return ApplicationList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/apps")
    ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted);

    /**
    * List Applications
    * Enumerates apps added to your organization with pagination. A subset of apps can be returned that match a supported filter expression or query.
    * @return ApplicationList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/apps")
    ApplicationList listApplications();


    /**
    * Add Application
    * Adds a new application to your Okta organization.
    * @param application  (required)
    * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
    * @param oktaAccessGatewayAgent  (optional)
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/apps")
    Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent);

    /**
    * Add Application
    * Adds a new application to your Okta organization.
    * @param application  (required)
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/apps")
    Application createApplication(Application application);


    /**
    * Get Application
    * Fetches an application from your Okta organization by &#x60;id&#x60;.
    * @param appId  (required)
    * @param expand  (optional)
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/apps/{appId}")
    Application getApplication(String appId, String expand);

    /**
    * Get Application
    * Fetches an application from your Okta organization by &#x60;id&#x60;.
    * @param appId  (required)
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/apps/{appId}")
    Application getApplication(String appId);


    /**
    * 
    * Success
    * @return AuthenticatorList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/authenticators")
    AuthenticatorList listAuthenticators();



    /**
    * 
    * Success
    * @param authenticatorId  (required)
    * @return Authenticator
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/authenticators/{authenticatorId}")
    Authenticator getAuthenticator(String authenticatorId);



    /**
    * 
    * Success
    * @param q  (optional)
    * @return AuthorizationServerList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/authorizationServers")
    AuthorizationServerList listAuthorizationServers(String q);

    /**
    * 
    * Success
    * @return AuthorizationServerList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/authorizationServers")
    AuthorizationServerList listAuthorizationServers();


    /**
    * 
    * Success
    * @param authorizationServer  (required)
    * @return AuthorizationServer
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/authorizationServers")
    AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer);



    /**
    * 
    * Success
    * @param authServerId  (required)
    * @return AuthorizationServer
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/authorizationServers/{authServerId}")
    AuthorizationServer getAuthorizationServer(String authServerId);



    /**
    * List Brands
    * List all the brands in your org.
    * @return BrandList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands")
    BrandList listBrands();



    /**
    * Get Brand
    * Fetches a brand by &#x60;brandId&#x60;
    * @param brandId  (required)
    * @return Brand
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}")
    Brand getBrand(String brandId);



    /**
    * List Email Templates
    * List email templates in your organization with pagination.
    * @param brandId  (required)
    * @return EmailTemplateList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/templates/email")
    EmailTemplateList listEmailTemplates(String brandId);



    /**
    * Get Brand Themes
    * List all the themes in your brand
    * @param brandId  (required)
    * @return ThemeResponseList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/themes")
    ThemeResponseList listBrandThemes(String brandId);



    /**
    * Get a theme for a brand
    * Fetches a theme for a brand
    * @param brandId  (required)
    * @param themeId  (required)
    * @return ThemeResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/brands/{brandId}/themes/{themeId}")
    ThemeResponse getBrandTheme(String brandId, String themeId);



    /**
    * List Domains
    * List all verified custom Domains for the org.
    * @return DomainListResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/domains")
    DomainListResponse listDomains();



    /**
    * Create Domain
    * Creates your domain.
    * @param domain  (required)
    * @return Domain
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/domains")
    Domain createDomain(Domain domain);



    /**
    * Delete Domain
    * Deletes a Domain by &#x60;id&#x60;.
    * @param domainId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/domains/{domainId}")
    void deleteDomain(String domainId);



    /**
    * Get Domain
    * Fetches a Domain by &#x60;id&#x60;.
    * @param domainId  (required)
    * @return Domain
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/domains/{domainId}")
    Domain getDomain(String domainId);



    /**
    * Verify Domain
    * Verifies the Domain by &#x60;id&#x60;.
    * @param domainId  (required)
    * @return Domain
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/domains/{domainId}/verify")
    Domain verifyDomain(String domainId);



    /**
    * 
    * Success
    * @return EventHookList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/eventHooks")
    EventHookList listEventHooks();



    /**
    * 
    * Success
    * @param eventHook  (required)
    * @return EventHook
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/eventHooks")
    EventHook createEventHook(EventHook eventHook);



    /**
    * 
    * Success
    * @param eventHookId  (required)
    * @return EventHook
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/eventHooks/{eventHookId}")
    EventHook getEventHook(String eventHookId);



    /**
    * 
    * Success
    * @return FeatureList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/features")
    FeatureList listFeatures();



    /**
    * 
    * Success
    * @param featureId  (required)
    * @return Feature
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/features/{featureId}")
    Feature getFeature(String featureId);



    /**
    * List Groups
    * Enumerates groups in your organization with pagination. A subset of groups can be returned that match a supported filter expression or query.
    * @param q Searches the name property of groups for matching value (optional)
    * @param search Filter expression for groups (optional)
    * @param expand If specified, it causes additional metadata to be included in the response. (optional)
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups")
    GroupList listGroups(String q, String search, String expand);

    /**
    * List Groups
    * Enumerates groups in your organization with pagination. A subset of groups can be returned that match a supported filter expression or query.
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups")
    GroupList listGroups();


    /**
    * Add Group
    * Adds a new group with &#x60;OKTA_GROUP&#x60; type to your organization.
    * @param group  (required)
    * @return Group
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/groups")
    Group createGroup(Group group);



    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @param search Specifies the keyword to search fules for (optional)
    * @param expand If specified as &#x60;groupIdToGroupNameMap&#x60;, then show group names (optional)
    * @return GroupRuleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/rules")
    GroupRuleList listGroupRules(String search, String expand);

    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @return GroupRuleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/rules")
    GroupRuleList listGroupRules();


    /**
    * Create Group Rule
    * Creates a group rule to dynamically add users to the specified group if they match the condition
    * @param groupRule  (required)
    * @return GroupRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/groups/rules")
    GroupRule createGroupRule(GroupRule groupRule);



    /**
    * Get Group Rule
    * Fetches a specific group rule by id from your organization
    * @param ruleId  (required)
    * @param expand  (optional)
    * @return GroupRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/rules/{ruleId}")
    GroupRule getGroupRule(String ruleId, String expand);

    /**
    * Get Group Rule
    * Fetches a specific group rule by id from your organization
    * @param ruleId  (required)
    * @return GroupRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/rules/{ruleId}")
    GroupRule getGroupRule(String ruleId);


    /**
    * List Group Rules
    * Fetches a group from your organization.
    * @param groupId  (required)
    * @return Group
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/{groupId}")
    Group getGroup(String groupId);



    /**
    * 
    * Success
    * @param groupId  (required)
    * @param expand  (optional)
    * @return RoleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles")
    RoleList listGroupAssignedRoles(String groupId, String expand);

    /**
    * 
    * Success
    * @param groupId  (required)
    * @return RoleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles")
    RoleList listGroupAssignedRoles(String groupId);


    /**
    * 
    * Unassigns a Role from a Group
    * @param groupId  (required)
    * @param roleId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/roles/{roleId}")
    void removeRoleFromGroup(String groupId, String roleId);



    /**
    * 
    * Success
    * @param groupId  (required)
    * @param roleId  (required)
    * @return Role
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles/{roleId}")
    Role getRole(String groupId, String roleId);



    /**
    * 
    * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a Group. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
    * @param groupId  (required)
    * @param roleId  (required)
    * @return CatalogApplicationList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps")
    CatalogApplicationList listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleId);



    /**
    * 
    * Success
    * @param groupId  (required)
    * @param roleId  (required)
    * @param appName  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}")
    void removeApplicationTargetFromApplicationAdministratorRoleGivenToGroup(String groupId, String roleId, String appName);



    /**
    * Remove App Instance Target to App Administrator Role given to a Group
    * Remove App Instance Target to App Administrator Role given to a Group
    * @param groupId  (required)
    * @param roleId  (required)
    * @param appName  (required)
    * @param applicationId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}")
    void removeApplicationTargetFromAdministratorRoleGivenToGroup(String groupId, String roleId, String appName, String applicationId);



    /**
    * 
    * Success
    * @param groupId  (required)
    * @param roleId  (required)
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/groups/{groupId}/roles/{roleId}/targets/groups")
    GroupList listGroupTargetsForGroupRole(String groupId, String roleId);



    /**
    * 
    * 
    * @param groupId  (required)
    * @param roleId  (required)
    * @param targetGroupId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}")
    void removeGroupTargetFromGroupAdministratorRoleGivenToGroup(String groupId, String roleId, String targetGroupId);



    /**
    * List Identity Providers
    * Enumerates IdPs in your organization with pagination. A subset of IdPs can be returned that match a supported filter expression or query.
    * @param q Searches the name property of IdPs for matching value (optional)
    * @param type Filters IdPs by type (optional)
    * @return IdentityProviderList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/idps")
    IdentityProviderList listIdentityProviders(String q, String type);

    /**
    * List Identity Providers
    * Enumerates IdPs in your organization with pagination. A subset of IdPs can be returned that match a supported filter expression or query.
    * @return IdentityProviderList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/idps")
    IdentityProviderList listIdentityProviders();


    /**
    * Add Identity Provider
    * Adds a new IdP to your organization.
    * @param identityProvider  (required)
    * @return IdentityProvider
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/idps")
    IdentityProvider createIdentityProvider(IdentityProvider identityProvider);



    /**
    * List Keys
    * Enumerates IdP key credentials.
    * @return JsonWebKeyList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/idps/credentials/keys")
    JsonWebKeyList listIdentityProviderKeys();



    /**
    * Add X.509 Certificate Public Key
    * Adds a new X.509 certificate credential to the IdP key store.
    * @param jsonWebKey  (required)
    * @return JsonWebKey
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/idps/credentials/keys")
    JsonWebKey createIdentityProviderKey(JsonWebKey jsonWebKey);



    /**
    * Delete Key
    * Deletes a specific IdP Key Credential by &#x60;kid&#x60; if it is not currently being used by an Active or Inactive IdP.
    * @param keyId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/idps/credentials/keys/{keyId}")
    void deleteIdentityProviderKey(String keyId);



    /**
    * Get Key
    * Gets a specific IdP Key Credential by &#x60;kid&#x60;
    * @param keyId  (required)
    * @return JsonWebKey
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/idps/credentials/keys/{keyId}")
    JsonWebKey getIdentityProviderKey(String keyId);



    /**
    * Get Identity Provider
    * Fetches an IdP by &#x60;id&#x60;.
    * @param idpId  (required)
    * @return IdentityProvider
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/idps/{idpId}")
    IdentityProvider getIdentityProvider(String idpId);



    /**
    * 
    * Update the Certificate Signing Request with a signed X.509 certificate and add it into the signing key credentials for the IdP.
    * @param idpId  (required)
    * @param csrId  (required)
    * @return JsonWebKey
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/idps/{idpId}/credentials/csrs/{csrId}/lifecycle/publish")
    JsonWebKey apiV1IdpsIdpIdCredentialsCsrsCsrIdLifecyclePublishPost(String idpId, String csrId);



    /**
    * 
    * Success
    * @param type  (optional)
    * @return InlineHookList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/inlineHooks")
    InlineHookList listInlineHooks(String type);

    /**
    * 
    * Success
    * @return InlineHookList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/inlineHooks")
    InlineHookList listInlineHooks();


    /**
    * 
    * Success
    * @param inlineHook  (required)
    * @return InlineHook
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/inlineHooks")
    InlineHook createInlineHook(InlineHook inlineHook);



    /**
    * 
    * Gets an inline hook by ID
    * @param inlineHookId  (required)
    * @return InlineHook
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/inlineHooks/{inlineHookId}")
    InlineHook getInlineHook(String inlineHookId);



    /**
    * Fetch a list of events from your Okta organization system log.
    * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
    * @param since  (optional)
    * @param until  (optional)
    * @param filter  (optional)
    * @param q  (optional)
    * @param sortOrder  (optional, default to ASCENDING)
    * @return LogEventList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/logs")
    LogEventList getLogs(Date since, Date until, String filter, String q, String sortOrder);

    /**
    * Fetch a list of events from your Okta organization system log.
    * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
    * @return LogEventList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/logs")
    LogEventList getLogs();


    /**
    * 
    * Enumerates Profile Mappings in your organization with pagination.
    * @param sourceId  (optional)
    * @param targetId  (optional, default to )
    * @return ProfileMappingList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/mappings")
    ProfileMappingList listProfileMappings(String sourceId, String targetId);

    /**
    * 
    * Enumerates Profile Mappings in your organization with pagination.
    * @return ProfileMappingList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/mappings")
    ProfileMappingList listProfileMappings();


    /**
    * Get Profile Mapping
    * Fetches a single Profile Mapping referenced by its ID.
    * @param mappingId  (required)
    * @return ProfileMapping
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/mappings/{mappingId}")
    ProfileMapping getProfileMapping(String mappingId);



    /**
    * Fetches the Schema for an App User
    * Fetches the Schema for an App User
    * @param appInstanceId  (required)
    * @return UserSchema
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/meta/schemas/apps/{appInstanceId}/default")
    UserSchema getApplicationUserSchema(String appInstanceId);



    /**
    * Partial updates on the User Profile properties of the Application User Schema.
    * Partial updates on the User Profile properties of the Application User Schema.
    * @param appInstanceId  (required)
    * @param body  (optional)
    * @return UserSchema
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/meta/schemas/apps/{appInstanceId}/default")
    UserSchema updateApplicationUserProfile(String appInstanceId, UserSchema body);

    /**
    * Partial updates on the User Profile properties of the Application User Schema.
    * Partial updates on the User Profile properties of the Application User Schema.
    * @param appInstanceId  (required)
    * @return UserSchema
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/meta/schemas/apps/{appInstanceId}/default")
    UserSchema updateApplicationUserProfile(String appInstanceId);


    /**
    * Fetches the group schema
    * Fetches the group schema
    * @return GroupSchema
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/meta/schemas/group/default")
    GroupSchema getGroupSchema();



    /**
    * Updates, adds ore removes one or more custom Group Profile properties in the schema
    * Updates, adds ore removes one or more custom Group Profile properties in the schema
    * @param body  (optional)
    * @return GroupSchema
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/meta/schemas/group/default")
    GroupSchema updateGroupSchema(GroupSchema body);

    /**
    * Updates, adds ore removes one or more custom Group Profile properties in the schema
    * Updates, adds ore removes one or more custom Group Profile properties in the schema
    * @return GroupSchema
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/meta/schemas/group/default")
    GroupSchema updateGroupSchema();


    /**
    * 
    * Success
    * @return LinkedObjectList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/meta/schemas/user/linkedObjects")
    LinkedObjectList listLinkedObjectDefinitions();



    /**
    * 
    * Success
    * @param linkedObject  (required)
    * @return LinkedObject
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/meta/schemas/user/linkedObjects")
    LinkedObject addLinkedObjectDefinition(LinkedObject linkedObject);



    /**
    * 
    * Success
    * @param linkedObjectName  (required)
    * @return LinkedObject
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/meta/schemas/user/linkedObjects/{linkedObjectName}")
    LinkedObject getLinkedObjectDefinition(String linkedObjectName);



    /**
    * Fetches the schema for a Schema Id.
    * Fetches the schema for a Schema Id.
    * @param schemaId  (required)
    * @return UserSchema
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/meta/schemas/user/{schemaId}")
    UserSchema getUserSchema(String schemaId);



    /**
    * 
    * Partial updates on the User Profile properties of the user schema.
    * @param schemaId  (required)
    * @param userSchema  (required)
    * @return UserSchema
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/meta/schemas/user/{schemaId}")
    UserSchema updateUserProfile(String schemaId, UserSchema userSchema);



    /**
    * 
    * Fetches all User Types in your org
    * @return UserTypeList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/meta/types/user")
    UserTypeList listUserTypes();



    /**
    * 
    * Creates a new User Type. A default User Type is automatically created along with your org, and you may add another 9 User Types for a maximum of 10.
    * @param userType  (required)
    * @return UserType
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/meta/types/user")
    UserType createUserType(UserType userType);



    /**
    * 
    * Fetches a User Type by ID. The special identifier &#x60;default&#x60; may be used to fetch the default User Type.
    * @param typeId  (required)
    * @return UserType
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/meta/types/user/{typeId}")
    UserType getUserType(String typeId);



    /**
    * Get org settings
    * Get settings of your organization.
    * @return OrgSetting
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/org")
    OrgSetting getOrgSettings();



    /**
    * 
    * Gets all policies with the specified type.
    * @param type  (required)
    * @param status  (optional)
    * @param expand  (optional, default to )
    * @return PolicyList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/policies")
    PolicyList listPolicies(String type, String status, String expand);

    /**
    * 
    * Gets all policies with the specified type.
    * @param type  (required)
    * @return PolicyList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/policies")
    PolicyList listPolicies(String type);


    /**
    * 
    * Creates a policy.
    * @param policy  (required)
    * @param activate  (optional, default to true)
    * @return Policy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/policies")
    Policy createPolicy(Policy policy, Boolean activate);

    /**
    * 
    * Creates a policy.
    * @param policy  (required)
    * @return Policy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/policies")
    Policy createPolicy(Policy policy);


    /**
    * 
    * Gets a policy.
    * @param policyId  (required)
    * @param expand  (optional, default to )
    * @return Policy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/policies/{policyId}")
    Policy getPolicy(String policyId, String expand);

    /**
    * 
    * Gets a policy.
    * @param policyId  (required)
    * @return Policy
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/policies/{policyId}")
    Policy getPolicy(String policyId);


    /**
    * Create Session with Session Token
    * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
    * @param createSessionRequest  (required)
    * @return Session
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/sessions")
    Session createSession(CreateSessionRequest createSessionRequest);



    /**
    * 
    * Get details about a session.
    * @param sessionId  (required)
    * @return Session
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/sessions/{sessionId}")
    Session getSession(String sessionId);



    /**
    * List SMS Templates
    * Enumerates custom SMS templates in your organization. A subset of templates can be returned that match a template type.
    * @param templateType  (optional)
    * @return SmsTemplateList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/templates/sms")
    SmsTemplateList listSmsTemplates(SmsTemplateType templateType);

    /**
    * List SMS Templates
    * Enumerates custom SMS templates in your organization. A subset of templates can be returned that match a template type.
    * @return SmsTemplateList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/templates/sms")
    SmsTemplateList listSmsTemplates();


    /**
    * Add SMS Template
    * Adds a new custom SMS template to your organization.
    * @param smsTemplate  (required)
    * @return SmsTemplate
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/templates/sms")
    SmsTemplate createSmsTemplate(SmsTemplate smsTemplate);



    /**
    * Get SMS Template
    * Fetches a specific template by &#x60;id&#x60;
    * @param templateId  (required)
    * @return SmsTemplate
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/templates/sms/{templateId}")
    SmsTemplate getSmsTemplate(String templateId);



    /**
    * 
    * Gets current ThreatInsight configuration
    * @return ThreatInsightConfiguration
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/threats/configuration")
    ThreatInsightConfiguration getCurrentConfiguration();



    /**
    * 
    * Success
    * @param q  (optional)
    * @param filter  (optional)
    * @return TrustedOriginList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/trustedOrigins")
    TrustedOriginList listOrigins(String q, String filter);

    /**
    * 
    * Success
    * @return TrustedOriginList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/trustedOrigins")
    TrustedOriginList listOrigins();


    /**
    * 
    * Success
    * @param trustedOrigin  (required)
    * @return TrustedOrigin
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/trustedOrigins")
    TrustedOrigin createOrigin(TrustedOrigin trustedOrigin);



    /**
    * 
    * Success
    * @param trustedOriginId  (required)
    * @return TrustedOrigin
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/trustedOrigins/{trustedOriginId}")
    TrustedOrigin getOrigin(String trustedOriginId);



    /**
    * 
    * Success
    * @param trustedOriginId  (required)
    * @return TrustedOrigin
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/trustedOrigins/{trustedOriginId}/lifecycle/activate")
    TrustedOrigin activateOrigin(String trustedOriginId);



    /**
    * 
    * Success
    * @param trustedOriginId  (required)
    * @return TrustedOrigin
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/trustedOrigins/{trustedOriginId}/lifecycle/deactivate")
    TrustedOrigin deactivateOrigin(String trustedOriginId);



    /**
    * List Users
    * Lists users in your organization with pagination in most cases.  A subset of users can be returned that match a supported filter expression or search criteria.
    * @param q Finds a user that matches firstName, lastName, and email properties (optional)
    * @param filter Filters users with a supported expression for a subset of properties (optional)
    * @param search Searches for users with a supported filtering  expression for most properties (optional)
    * @param sortBy  (optional)
    * @param sortOrder  (optional)
    * @return UserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users")
    UserList listUsers(String q, String filter, String search, String sortBy, String sortOrder);

    /**
    * List Users
    * Lists users in your organization with pagination in most cases.  A subset of users can be returned that match a supported filter expression or search criteria.
    * @return UserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users")
    UserList listUsers();


    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
    * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
    * @param nextLogin With activate&#x3D;true, set nextLogin to \&quot;changePassword\&quot; to have the password be EXPIRED, so user must change it the next time they log in. (optional, default to )
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/users")
    User createUser(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin);

    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/users")
    User createUser(CreateUserRequest body);


    /**
    * Get User
    * Fetches a user from your Okta organization.
    * @param userId  (required)
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users/{userId}")
    User getUser(String userId);



    /**
    * 
    * Fetch a user by &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; if the short name is unambiguous.
    * @param user  (required)
    * @param userId  (required)
    * @param strict  (optional)
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/users/{userId}")
    User partialUpdateUser(User user, String userId, Boolean strict);

    /**
    * 
    * Fetch a user by &#x60;id&#x60;, &#x60;login&#x60;, or &#x60;login shortname&#x60; if the short name is unambiguous.
    * @param user  (required)
    * @param userId  (required)
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/users/{userId}")
    User partialUpdateUser(User user, String userId);


    /**
    * 
    * Lists all grants for a specified user and client
    * @param userId  (required)
    * @param clientId  (required)
    * @param expand  (optional)
    * @return OAuth2ScopeConsentGrantList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users/{userId}/clients/{clientId}/grants")
    OAuth2ScopeConsentGrantList listGrantsForUserAndClient(String userId, String clientId, String expand);

    /**
    * 
    * Lists all grants for a specified user and client
    * @param userId  (required)
    * @param clientId  (required)
    * @return OAuth2ScopeConsentGrantList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users/{userId}/clients/{clientId}/grants")
    OAuth2ScopeConsentGrantList listGrantsForUserAndClient(String userId, String clientId);


    /**
    * 
    * Polls factors verification transaction for status.
    * @param userId  (required)
    * @param factorId  (required)
    * @param transactionId  (required)
    * @return VerifyUserFactorResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}")
    VerifyUserFactorResponse getFactorTransactionStatus(String userId, String factorId, String transactionId);



    /**
    * 
    * Gets a grant for the specified user
    * @param userId  (required)
    * @param grantId  (required)
    * @param expand  (optional)
    * @return OAuth2ScopeConsentGrant
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users/{userId}/grants/{grantId}")
    OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId, String expand);

    /**
    * 
    * Gets a grant for the specified user
    * @param userId  (required)
    * @param grantId  (required)
    * @return OAuth2ScopeConsentGrant
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users/{userId}/grants/{grantId}")
    OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId);


    /**
    * 
    * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a User. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
    * @param userId  (required)
    * @param roleId  (required)
    * @return CatalogApplicationList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps")
    CatalogApplicationList listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleId);



    /**
    * 
    * Success
    * @param userId  (required)
    * @param roleId  (required)
    * @param appName  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}")
    void removeApplicationTargetFromApplicationAdministratorRoleForUser(String userId, String roleId, String appName);



    /**
    * Remove App Instance Target to App Administrator Role given to a User
    * Remove App Instance Target to App Administrator Role given to a User
    * @param userId  (required)
    * @param roleId  (required)
    * @param appName  (required)
    * @param applicationId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}")
    void removeApplicationTargetFromAdministratorRoleForUser(String userId, String roleId, String appName, String applicationId);



    /**
    * List Network Zones
    * Enumerates network zones added to your organization with pagination. A subset of zones can be returned that match a supported filter expression or query.
    * @param filter Filters zones by usage or id expression (optional)
    * @return NetworkZoneList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/zones")
    NetworkZoneList listNetworkZones(String filter);

    /**
    * List Network Zones
    * Enumerates network zones added to your organization with pagination. A subset of zones can be returned that match a supported filter expression or query.
    * @return NetworkZoneList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/zones")
    NetworkZoneList listNetworkZones();


    /**
    * Add Network Zone
    * Adds a new network zone to your Okta organization.
    * @param zone  (required)
    * @return NetworkZone
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "POST - /api/v1/zones")
    NetworkZone createNetworkZone(NetworkZone zone);



    /**
    * Get Network Zone
    * Fetches a network zone from your Okta organization by &#x60;id&#x60;.
    * @param zoneId  (required)
    * @return NetworkZone
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2022-04-28T13:49:19.036-05:00",
            comments = "GET - /api/v1/zones/{zoneId}")
    NetworkZone getNetworkZone(String zoneId);



}
